/*
 * Decompiled with CFR 0.152.
 */
package se.kodapan.osm.services.overpass;

import java.io.StringReader;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.util.Collection;
import se.kodapan.osm.domain.Node;
import se.kodapan.osm.domain.OsmObject;
import se.kodapan.osm.domain.OsmObjectVisitor;
import se.kodapan.osm.domain.Relation;
import se.kodapan.osm.domain.Way;
import se.kodapan.osm.domain.root.PojoRoot;
import se.kodapan.osm.parser.xml.OsmXmlParserException;
import se.kodapan.osm.parser.xml.instantiated.InstantiatedOsmXmlParser;
import se.kodapan.osm.services.overpass.Overpass;
import se.kodapan.osm.services.overpass.OverpassException;

public class OverpassUtils {
    private Overpass overpass;
    private static OsmObjectVisitor<String> getObjectType = new OsmObjectVisitor<String>(){

        @Override
        public String visit(Node node) {
            return "node";
        }

        @Override
        public String visit(Way way) {
            return "way";
        }

        @Override
        public String visit(Relation relation) {
            return "relation";
        }
    };

    public OverpassUtils(Overpass overpass) {
        this.overpass = overpass;
    }

    public void loadAllObjects(PojoRoot pojoRoot) throws OverpassException, OsmXmlParserException {
        InstantiatedOsmXmlParser instantiatedOsmXmlParser = InstantiatedOsmXmlParser.newInstance();
        instantiatedOsmXmlParser.setRoot(pojoRoot);
        for (Node osmObject : pojoRoot.getNodes().values()) {
            if (osmObject.isLoaded()) continue;
            this.loadNode(instantiatedOsmXmlParser, osmObject.getId());
        }
        for (Way way : pojoRoot.getWays().values()) {
            if (way.isLoaded()) continue;
            this.loadWay(instantiatedOsmXmlParser, way.getId());
        }
        for (Relation relation : pojoRoot.getRelations().values()) {
            if (relation.isLoaded()) continue;
            this.loadRelation(instantiatedOsmXmlParser, relation.getId());
        }
    }

    public Node getNode(long l) throws Exception {
        return this.loadNode(InstantiatedOsmXmlParser.newInstance(), l);
    }

    public void loadObjects(InstantiatedOsmXmlParser instantiatedOsmXmlParser, Collection<? extends OsmObject> collection) throws OverpassException, OsmXmlParserException {
        StringWriter stringWriter = new StringWriter(1000 + collection.size() * 40);
        stringWriter.write("<osm-script>\n");
        for (OsmObject osmObject : collection) {
            stringWriter.append("  <id-query ref=\"");
            stringWriter.append("\" type=\"");
            stringWriter.append(osmObject.accept(getObjectType));
            stringWriter.append("\" />\n");
        }
        stringWriter.append("  <print/>\n");
        stringWriter.append("</osm-script>");
        String string = this.overpass.execute(stringWriter.toString(), "Fetching " + collection.size() + " objects by identity...");
        instantiatedOsmXmlParser.parse(new StringReader(string));
    }

    public Node loadNode(InstantiatedOsmXmlParser instantiatedOsmXmlParser, long l) throws OverpassException, OsmXmlParserException {
        String string = this.overpass.execute("<osm-script>\n  <id-query ref=\"" + l + "\" type=\"node\"/>\n  <print/>\n</osm-script>", "Getting node " + l);
        instantiatedOsmXmlParser.parse(new StringReader(string));
        return instantiatedOsmXmlParser.getRoot().getNode(l);
    }

    public Way loadWay(long l) throws OverpassException, OsmXmlParserException {
        return this.loadWay(InstantiatedOsmXmlParser.newInstance(), l);
    }

    public Way loadWay(InstantiatedOsmXmlParser instantiatedOsmXmlParser, long l) throws OverpassException, OsmXmlParserException {
        instantiatedOsmXmlParser.parse(new StringReader(this.overpass.execute("<osm-script>\n  <id-query ref=\"" + l + "\" type=\"way\"/>\n  <print/>\n</osm-script>", "Getting way " + l)));
        instantiatedOsmXmlParser.parse(new StringReader(this.overpass.execute("<osm-script>\n  <id-query ref=\"" + l + "\" type=\"way\"/>\n  <recurse type=\"way-node\"/>\n\n  <print/>\n</osm-script>", "Getting way " + l)));
        return instantiatedOsmXmlParser.getRoot().getWay(l);
    }

    public Relation loadRelation(long l) throws OverpassException, OsmXmlParserException {
        return this.loadRelation(InstantiatedOsmXmlParser.newInstance(), l);
    }

    public Relation loadRelation(InstantiatedOsmXmlParser instantiatedOsmXmlParser, long l) throws OverpassException, OsmXmlParserException {
        instantiatedOsmXmlParser.parse(new StringReader(this.overpass.execute("<osm-script>\n  <id-query ref=\"" + l + "\" type=\"relation\"/>\n  <print/>\n</osm-script>", "Getting relation " + l)));
        instantiatedOsmXmlParser.parse(new StringReader(this.overpass.execute("<osm-script>\n  <union>\n    <id-query ref=\"" + l + "\" type=\"relation\"/>\n  <recurse type=\"relation-way\"/>\n  <recurse type=\"way-node\"/>\n  </union>\n  <print/>\n</osm-script>", "Getting relation nodes" + l)));
        return instantiatedOsmXmlParser.getRoot().getRelation(l);
    }

    public void loadEnvelope(InstantiatedOsmXmlParser instantiatedOsmXmlParser, double d, double d2, double d3, double d4) throws OverpassException, OsmXmlParserException {
        this.loadEnvelope(instantiatedOsmXmlParser, d, d2, d3, d4, null);
    }

    public void loadEnvelope(InstantiatedOsmXmlParser instantiatedOsmXmlParser, double d, double d2, double d3, double d4, String string) throws OverpassException, OsmXmlParserException {
        if (string == null) {
            string = "";
        }
        DecimalFormat decimalFormat = new DecimalFormat("#.#####################");
        String string2 = "<bbox-query s=\"" + decimalFormat.format(d) + "\" n=\"" + decimalFormat.format(d3) + "\" w=\"" + decimalFormat.format(d2) + "\" e=\"" + decimalFormat.format(d4) + "\"/>";
        instantiatedOsmXmlParser.parse(new StringReader(this.overpass.execute("<osm-script>\n  " + string2 + "\n  " + string + "\n  <print/>\n</osm-script>", "Getting nodes in bbox " + string2)));
        instantiatedOsmXmlParser.parse(new StringReader(this.overpass.execute("<osm-script>\n  " + string2 + "\n  " + string + "\n  <recurse type=\"node-way\"/>  <print/>\n</osm-script>", "Getting ways in bbox " + string2)));
        instantiatedOsmXmlParser.parse(new StringReader(this.overpass.execute("<osm-script>\n  " + string2 + "\n  " + string + "\n  <recurse type=\"node-relation\"/>  <print/>\n</osm-script>", "Getting relations in bbox " + string2)));
    }

    public PojoRoot runQuery(String string) throws OverpassException, OsmXmlParserException {
        return this.runQuery(InstantiatedOsmXmlParser.newInstance(), string);
    }

    private PojoRoot runQuery(InstantiatedOsmXmlParser instantiatedOsmXmlParser, String string) throws OsmXmlParserException, OverpassException {
        instantiatedOsmXmlParser.parse(new StringReader(this.overpass.execute(string, "Running query " + string)));
        return (PojoRoot)instantiatedOsmXmlParser.getRoot();
    }
}

