/*
 * Decompiled with CFR 0.152.
 */
package se.kodapan.osm.domain.root;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import se.kodapan.osm.domain.Node;
import se.kodapan.osm.domain.OsmObject;
import se.kodapan.osm.domain.OsmObjectVisitor;
import se.kodapan.osm.domain.Relation;
import se.kodapan.osm.domain.RelationMembership;
import se.kodapan.osm.domain.Way;
import se.kodapan.osm.domain.root.AbstractRoot;
import se.kodapan.osm.domain.root.Root;

public class PojoRoot
extends AbstractRoot
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<Long, Node> nodes = new HashMap<Long, Node>();
    private Map<Long, Way> ways = new HashMap<Long, Way>();
    private Map<Long, Relation> relations = new HashMap<Long, Relation>();
    private OsmObjectVisitor<Set<OsmObject>> removeVisitor = new RemoveVisitor();
    private OsmObjectVisitor<Void> addVisitor = new AddVisitor();

    @Override
    public Root.Enumerator<Node> enumerateNodes() {
        return new Root.Enumerator<Node>(){
            Iterator<Map.Entry<Long, Node>> iterator;
            {
                this.iterator = PojoRoot.this.getNodes().entrySet().iterator();
            }

            @Override
            public Node next() {
                return this.iterator.hasNext() ? this.iterator.next().getValue() : null;
            }
        };
    }

    @Override
    public Root.Enumerator<Way> enumerateWays() {
        return new Root.Enumerator<Way>(){
            Iterator<Map.Entry<Long, Way>> iterator;
            {
                this.iterator = PojoRoot.this.getWays().entrySet().iterator();
            }

            @Override
            public Way next() {
                return this.iterator.hasNext() ? this.iterator.next().getValue() : null;
            }
        };
    }

    @Override
    public Root.Enumerator<Relation> enumerateRelations() {
        return new Root.Enumerator<Relation>(){
            Iterator<Map.Entry<Long, Relation>> iterator;
            {
                this.iterator = PojoRoot.this.getRelations().entrySet().iterator();
            }

            @Override
            public Relation next() {
                return this.iterator.hasNext() ? this.iterator.next().getValue() : null;
            }
        };
    }

    @Override
    public Node getNode(long l) {
        return this.getNodes().get(l);
    }

    @Override
    public Way getWay(long l) {
        return this.getWays().get(l);
    }

    @Override
    public Relation getRelation(long l) {
        return this.getRelations().get(l);
    }

    @Override
    public Set<OsmObject> remove(OsmObject osmObject) {
        Set<OsmObject> set = osmObject.accept(this.removeVisitor);
        return set;
    }

    @Override
    public void add(OsmObject osmObject) {
        osmObject.accept(this.addVisitor);
    }

    public Map<Long, Node> getNodes() {
        return this.nodes;
    }

    public void setNodes(Map<Long, Node> map) {
        this.nodes = map;
    }

    public Map<Long, Way> getWays() {
        return this.ways;
    }

    public void setWays(Map<Long, Way> map) {
        this.ways = map;
    }

    public Map<Long, Relation> getRelations() {
        return this.relations;
    }

    public void setRelations(Map<Long, Relation> map) {
        this.relations = map;
    }

    public Collection<OsmObject> filter(OsmObjectVisitor<Boolean> osmObjectVisitor) {
        return this.filter(this.gatherAllOsmObjects(), osmObjectVisitor);
    }

    public Collection<OsmObject> filter(Collection<OsmObject> collection, OsmObjectVisitor<Boolean> osmObjectVisitor) {
        ArrayList<OsmObject> arrayList = new ArrayList<OsmObject>(collection);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            OsmObject osmObject = (OsmObject)iterator.next();
            if (!osmObject.accept(osmObjectVisitor).booleanValue()) continue;
            iterator.remove();
        }
        return arrayList;
    }

    public Set<OsmObject> gatherAllOsmObjects() {
        HashSet<OsmObject> hashSet = new HashSet<OsmObject>(this.getWays().size() + this.getRelations().size() + this.getNodes().size());
        hashSet.addAll(this.getWays().values());
        hashSet.addAll(this.getRelations().values());
        hashSet.addAll(this.getNodes().values());
        return hashSet;
    }

    public List<Node> findNodeByLatitudeAndLongitude(double d, double d2) {
        ArrayList<Node> arrayList = new ArrayList<Node>(100);
        for (Node node : this.getNodes().values()) {
            if (node.getLatitude() != d || node.getLongitude() != d2) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    public Node findFirstNodeByLatitudeAndLongitude(double d, double d2) {
        for (Node node : this.getNodes().values()) {
            if (node.getLatitude() != d || node.getLongitude() != d2) continue;
            return node;
        }
        return null;
    }

    public class AddVisitor
    implements OsmObjectVisitor<Void>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public Void visit(Node node) {
            PojoRoot.this.getNodes().put(node.getId(), node);
            return null;
        }

        @Override
        public Void visit(Way way) {
            PojoRoot.this.getWays().put(way.getId(), way);
            return null;
        }

        @Override
        public Void visit(Relation relation) {
            PojoRoot.this.getRelations().put(relation.getId(), relation);
            return null;
        }
    }

    public class RemoveVisitor
    implements OsmObjectVisitor<Set<OsmObject>>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public Set<OsmObject> visit(Node node) {
            HashSet<OsmObject> hashSet = new HashSet<OsmObject>(1024);
            if (node.getWaysMemberships() != null) {
                for (Way serializable : node.getWaysMemberships()) {
                    serializable.getNodes().remove(node);
                    hashSet.add(serializable);
                }
            }
            node.setWaysMemberships(null);
            if (node.getRelationMemberships() != null) {
                for (RelationMembership relationMembership : node.getRelationMemberships()) {
                    relationMembership.getRelation().getMembers().remove(relationMembership);
                    hashSet.add(relationMembership.getRelation());
                }
            }
            node.setRelationMemberships(null);
            PojoRoot.this.getNodes().remove(node.getId());
            return hashSet;
        }

        @Override
        public Set<OsmObject> visit(Way way) {
            HashSet<OsmObject> hashSet = new HashSet<OsmObject>(1024);
            if (way.getNodes() != null) {
                for (Node serializable : way.getNodes()) {
                    serializable.getWaysMemberships().remove(way);
                    hashSet.add(serializable);
                }
                way.setNodes(null);
            }
            if (way.getRelationMemberships() != null) {
                for (RelationMembership relationMembership : way.getRelationMemberships()) {
                    relationMembership.getRelation().getMembers().remove(relationMembership);
                    hashSet.add(relationMembership.getRelation());
                }
                way.setRelationMemberships(null);
            }
            return hashSet;
        }

        @Override
        public Set<OsmObject> visit(Relation relation) {
            HashSet<OsmObject> hashSet = new HashSet<OsmObject>(1024);
            if (relation.getMembers() != null) {
                for (RelationMembership relationMembership : relation.getMembers()) {
                    relationMembership.getObject().getRelationMemberships().remove(relationMembership);
                    if (!relationMembership.getObject().getRelationMemberships().isEmpty()) continue;
                    relationMembership.getObject().setRelationMemberships(null);
                    hashSet.add(relationMembership.getObject());
                }
                relation.setMembers(null);
            }
            return hashSet;
        }
    }
}

