/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.widget;

import eu.fuegenstein.swing.Widget;
import eu.fuegenstein.util.IProgressReporter;
import eu.fuegenstein.util.ProgressInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;

public class ProgressWidget
extends Widget
implements IProgressReporter {
    private JPanel titlePanel = new JPanel(new BorderLayout());
    private JLabel title = new JLabel();
    private JPanel barPanel = new JPanel();
    private JLabel footer = new JLabel();
    private JLabel cancelLabel = new JLabel();
    private final Dimension barDimension = new Dimension(360, 40);
    private Map<ProgressInfo, ProgressBarPanel> progressItems = new HashMap<ProgressInfo, ProgressBarPanel>();
    private boolean isCancelled = false;
    private static final long serialVersionUID = 5518506687851519071L;

    public ProgressWidget() {
        this.corner = 0;
        this.setupPanels();
    }

    public String getTitle() {
        return this.title.getText();
    }

    @Override
    public void setTitle(String string) {
        this.title.setText(string);
    }

    @Override
    public void setFooter(String string) {
        this.footer.setText(string);
        this.footer.setVisible(true);
    }

    private void setupPanels() {
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        Font font = this.title.getFont();
        this.title.setFont(new Font(font.getName(), 1, font.getSize()));
        this.titlePanel.add((Component)this.title, "Before");
        JLabel jLabel = new JLabel();
        jLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/gpsmaster/icons/cancel.png")));
        jLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ProgressWidget.this.isCancelled = true;
                ProgressWidget.this.cancelLabel.setVisible(true);
            }
        });
        this.titlePanel.add((Component)jLabel, "After");
        this.titlePanel.setBackground(this.BACKGROUNDCOLOR);
        this.titlePanel.setBorder(new EmptyBorder(6, 6, 2, 6));
        this.add((Component)this.titlePanel, "North");
        this.barPanel.setLayout(new BoxLayout(this.barPanel, 1));
        this.barPanel.setBackground(this.BACKGROUNDCOLOR);
        this.add((Component)this.barPanel, "Center");
        this.cancelLabel.setBackground(this.BACKGROUNDCOLOR);
        this.cancelLabel.setText("Cancelling ...");
        this.cancelLabel.setForeground(Color.RED);
        this.cancelLabel.setVisible(false);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(this.BACKGROUNDCOLOR);
        jPanel.setLayout(new FlowLayout(0));
        jPanel.setBorder(new EmptyBorder(2, 6, 2, 6));
        jPanel.add(this.cancelLabel);
        jPanel.add(this.footer);
        this.footer.setVisible(false);
        this.add((Component)jPanel, "South");
    }

    @Override
    public void addProgressItem(ProgressInfo progressInfo) {
        ProgressBarPanel progressBarPanel = new ProgressBarPanel();
        progressBarPanel.setMaximum(progressInfo.getMaxValue());
        progressBarPanel.setMinimum(progressInfo.getMinValue());
        progressBarPanel.setValue(progressInfo.getValue());
        progressBarPanel.setTitle(progressInfo.getName());
        progressBarPanel.setPreferredSize(this.barDimension);
        progressBarPanel.setStringPainted(false);
        progressBarPanel.setBackground(this.BACKGROUNDCOLOR);
        progressBarPanel.setBarForeground(Color.BLUE);
        progressBarPanel.setBorder(new EmptyBorder(2, 6, 2, 6));
        progressBarPanel.setVisible(true);
        this.progressItems.put(progressInfo, progressBarPanel);
        this.barPanel.add(progressBarPanel);
        this.setVisible(true);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void removeProgressItem(ProgressInfo progressInfo) {
        if (this.progressItems.containsKey(progressInfo)) {
            ProgressBarPanel progressBarPanel = this.progressItems.get(progressInfo);
            this.barPanel.remove(progressBarPanel);
            this.progressItems.remove(progressInfo);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void cancel() {
        this.isCancelled = true;
        this.cancelLabel.setVisible(true);
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public void update() {
        for (Map.Entry<ProgressInfo, ProgressBarPanel> entry : this.progressItems.entrySet()) {
            ProgressInfo progressInfo = entry.getKey();
            ProgressBarPanel progressBarPanel = entry.getValue();
            progressBarPanel.setTitle(progressInfo.getName());
            progressBarPanel.setValue(progressInfo.getValue());
            progressBarPanel.setMaximum(progressInfo.getMaxValue());
        }
    }

    @Override
    public void reset() {
        this.isCancelled = false;
        this.cancelLabel.setVisible(false);
        for (Map.Entry<ProgressInfo, ProgressBarPanel> entry : this.progressItems.entrySet()) {
            ProgressBarPanel progressBarPanel = entry.getValue();
            progressBarPanel.setValue(0);
        }
    }

    @Override
    public void clear() {
        this.isCancelled = false;
        this.cancelLabel.setVisible(false);
        this.progressItems.clear();
    }

    protected class ProgressBarPanel
    extends JPanel {
        private static final long serialVersionUID = -378363835389776194L;
        private final JProgressBar progressBar = new JProgressBar();
        private final JLabel titleLabel = new JLabel();

        public ProgressBarPanel() {
            this.setLayout(new BoxLayout(this, 1));
            this.titleLabel.setVisible(false);
            this.titleLabel.setAlignmentX(0.0f);
            this.add(this.titleLabel);
            this.add(this.progressBar);
        }

        public void setTitle(String string) {
            this.titleLabel.setText(string);
            this.titleLabel.setVisible(string != null);
        }

        public void setMinimum(int n) {
            this.progressBar.setMinimum(n);
        }

        public void setMaximum(int n) {
            this.progressBar.setMaximum(n);
        }

        public void setValue(int n) {
            this.progressBar.setValue(n);
        }

        public void setStringPainted(boolean bl) {
            this.progressBar.setStringPainted(bl);
        }

        public void setBarForeground(Color color) {
            this.progressBar.setForeground(color);
        }

        @Override
        public void setBackground(Color color) {
            super.setBackground(color);
            if (this.progressBar != null) {
                this.progressBar.setBackground(color);
            }
        }
    }
}

