/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.widget;

import eu.fuegenstein.swing.Widget;
import java.awt.Color;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import org.gpsmaster.GpsMaster;

public class ActivityWidget
extends Widget {
    private static final long serialVersionUID = 4245359012331910150L;
    private JButton btnActivity = new JButton();
    private JLabel lblActivity = new JLabel();
    private final String unknown = "Unknown";
    private String activity = "Unknown";

    public ActivityWidget() {
        super(1);
        this.setup();
    }

    public ActivityWidget(int n) {
        super(n);
        this.setup();
    }

    public ActivityWidget(String string) {
        this.activity = string;
        this.setup();
    }

    private void setup() {
        this.setLayout(new BoxLayout(this, 1));
        this.setOpaque(false);
        this.btnActivity.setOpaque(false);
        this.btnActivity.setVisible(true);
        this.btnActivity.setBackground(Color.WHITE);
        this.btnActivity.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.btnActivity.setAlignmentX(0.5f);
        this.btnActivity.setToolTipText("Click to set activity");
        this.add(this.btnActivity);
        this.lblActivity.setOpaque(true);
        this.lblActivity.setVisible(true);
        this.lblActivity.setForeground(Color.BLACK);
        this.lblActivity.setBackground(this.BACKGROUNDCOLOR);
        this.lblActivity.setAlignmentX(0.5f);
        this.lblActivity.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.add(this.lblActivity);
        this.setActivity(this.activity);
    }

    public String getActivity() {
        return this.activity;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.btnActivity.setEnabled(bl);
    }

    public void setActivity(String string) {
        this.activity = string;
        String string2 = "/org/gpsmaster/icons/activities/".concat(string).concat(".png");
        ImageIcon imageIcon = null;
        try {
            imageIcon = new ImageIcon(GpsMaster.class.getResource(string2));
            this.btnActivity.setIcon(imageIcon);
            if (string.equals("_notset")) {
                this.lblActivity.setText("(Activity not set)");
            } else {
                this.lblActivity.setText(string);
            }
        }
        catch (NullPointerException nullPointerException) {
            imageIcon = new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/activities/".concat("_noicon.png")));
            this.btnActivity.setIcon(imageIcon);
            this.lblActivity.setText(string);
        }
        this.validate();
    }

    public void addActionListener(ActionListener actionListener) {
        if (actionListener != null) {
            this.btnActivity.addActionListener(actionListener);
        }
    }
}

