/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.tree;

import eu.fuegenstein.swing.PlainColorIcon;
import java.awt.Color;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.tree.TreeNode;
import org.gpsmaster.GpsMaster;
import org.gpsmaster.gpxpanel.GPXObject;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.marker.Marker;
import org.gpsmaster.tree.GPXTreeComponent;

public class GPXTreeComponentFactory {
    private static ImageIcon visible;
    private static ImageIcon invisible;
    private static ImageIcon wptShow;
    private static ImageIcon wptHide;
    private static boolean boldSelectionStyle;

    public GPXTreeComponentFactory() {
        try {
            visible = new ImageIcon(ImageIO.read(GpsMaster.class.getResourceAsStream("/org/gpsmaster/icons/tree/tree-visible.png")));
            invisible = new ImageIcon(ImageIO.read(GpsMaster.class.getResourceAsStream("/org/gpsmaster/icons/tree/tree-invisible.png")));
            wptShow = new ImageIcon(ImageIO.read(GpsMaster.class.getResourceAsStream("/org/gpsmaster/icons/tree/tree-wpt-show.png")));
            wptHide = new ImageIcon(ImageIO.read(GpsMaster.class.getResourceAsStream("/org/gpsmaster/icons/tree/tree-wpt-hide.png")));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public JPanel getComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        TreeNode treeNode;
        JLabel jLabel = new JLabel();
        jLabel.setAlignmentX(0.5f);
        jLabel.setAlignmentY(0.5f);
        jLabel.setBorder(new EmptyBorder(0, 0, 0, 4));
        JLabel jLabel2 = new JLabel();
        jLabel2.setAlignmentX(0.5f);
        jLabel2.setAlignmentY(0.5f);
        jLabel2.setBorder(new EmptyBorder(0, 0, 0, 4));
        JLabel jLabel3 = new JLabel();
        jLabel3.setAlignmentX(0.5f);
        jLabel3.setAlignmentY(0.5f);
        JLabel jLabel4 = new JLabel();
        JPanel jPanel = null;
        if (object instanceof GPXObject) {
            jPanel = new GPXTreeComponent(jLabel, jLabel3, jLabel2, jLabel4);
            treeNode = (GPXObject)object;
            jLabel4.setText(treeNode.toString());
            if (((GPXObject)treeNode).isVisible()) {
                jLabel.setIcon(visible);
            } else {
                jLabel.setIcon(invisible);
            }
            if (((GPXObject)treeNode).isTrackPtsVisible()) {
                jLabel2.setIcon(wptShow);
            } else {
                jLabel2.setIcon(wptHide);
            }
            jLabel3.setIcon(new PlainColorIcon(((GPXObject)treeNode).getColor(), 7));
            jLabel3.setOpaque(true);
            jLabel3.setBorder(new CompoundBorder(new EmptyBorder(0, 0, 0, 4), new LineBorder(Color.black, 1, false)));
            jLabel3.setBackground(Color.white);
        }
        if (object instanceof Marker) {
            treeNode = (Marker)object;
            jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.add(new JLabel(((Marker)treeNode).getIcon()));
            String string = ((Waypoint)((Object)treeNode)).getName();
            if (string.isEmpty() || string == null) {
                jLabel4.setText(String.format("(%f, %f)", ((Waypoint)((Object)treeNode)).getLat(), ((Waypoint)((Object)treeNode)).getLon()));
            } else {
                jLabel4.setText(string);
            }
            jPanel.add(jLabel4);
        }
        jLabel4.setOpaque(true);
        if (bl) {
            jLabel4.setBackground(new Color(209, 230, 255));
            jLabel4.setBorder(new LineBorder(new Color(132, 172, 221), 1, false));
            if (boldSelectionStyle) {
                // empty if block
            }
        } else {
            jLabel4.setBackground(Color.white);
            jLabel4.setBorder(new LineBorder(Color.white, 1, false));
        }
        jPanel.setFocusable(false);
        jPanel.setBackground(Color.white);
        return jPanel;
    }

    static {
        boldSelectionStyle = false;
    }
}

