/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.timeshift;

import eu.fuegenstein.parameter.DurationParameter;
import eu.fuegenstein.parameter.RadioButtonParameter;
import java.util.Date;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.gpxpanel.WaypointGroup;
import org.gpsmaster.timeshift.TimeshiftAlgorithm;

public class ShiftTime
extends TimeshiftAlgorithm {
    private DurationParameter durationParameter = new DurationParameter(3600L);
    private RadioButtonParameter direction = new RadioButtonParameter();
    private final String DIR_PAST = "past";
    private final String DIR_FUTURE = "future";
    private long undoDelta = 0L;
    private String dateFormat = "HH:mm:ss";

    public ShiftTime() {
        this.setName("Shift Time");
        this.setDescription("Shift trackpoint times forward or backward");
        this.durationParameter.setFormat(this.dateFormat);
        this.durationParameter.setName("Delta");
        this.durationParameter.setDescription("shift time by");
        this.params.add(this.durationParameter);
        this.direction.setName("Direction");
        this.direction.setDescription("Direction");
        this.direction.addValue("past");
        this.direction.addValue("future");
        this.direction.setValue("past");
        this.params.add(this.direction);
    }

    @Override
    public boolean isApplicable() {
        return this.waypointGroups.size() > 0;
    }

    @Override
    public void apply() {
        long l = this.durationParameter.getValue() * 1000L;
        if (this.direction.getValueString().equals("past")) {
            l *= -1L;
        }
        this.undoDelta = l * -1L;
        this.doShift(l);
    }

    @Override
    public String getUndoDescription() {
        return this.getName() + " " + this.durationParameter.getValueString() + " " + this.direction.getValueString();
    }

    @Override
    public void undo() {
        this.doShift(this.undoDelta);
    }

    private void doShift(long l) {
        for (WaypointGroup waypointGroup : this.waypointGroups) {
            for (Waypoint waypoint : waypointGroup.getWaypoints()) {
                Date date = waypoint.getTime();
                if (date == null) continue;
                Date date2 = new Date(date.getTime() + l);
                waypoint.setTime(date2);
            }
        }
    }
}

