/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.timeshift;

import java.util.Date;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.gpxpanel.WaypointGroup;
import org.gpsmaster.timeshift.TimeshiftAlgorithm;
import org.joda.time.DateTimeZone;

public class LocalToUTC
extends TimeshiftAlgorithm {
    public LocalToUTC() {
        this.name = "Local to UTC";
        this.description = "assumed that the timestamps are in local time, this algorithm converts the timestamps to UTC, as required by the GPX definition.";
    }

    @Override
    public boolean isApplicable() {
        return this.waypointGroups.size() > 0;
    }

    @Override
    public void apply() {
        DateTimeZone dateTimeZone = DateTimeZone.getDefault();
        for (WaypointGroup waypointGroup : this.waypointGroups) {
            for (Waypoint waypoint : waypointGroup.getWaypoints()) {
                Date date = waypoint.getTime();
                if (date == null) continue;
                waypoint.setTime(new Date(dateTimeZone.convertLocalToUTC(date.getTime(), false)));
            }
        }
    }

    @Override
    public String getUndoDescription() {
        return "UTC to Local";
    }

    @Override
    public void undo() {
        DateTimeZone dateTimeZone = DateTimeZone.getDefault();
        for (WaypointGroup waypointGroup : this.waypointGroups) {
            for (Waypoint waypoint : waypointGroup.getWaypoints()) {
                Date date = waypoint.getTime();
                if (date == null) continue;
                waypoint.setTime(new Date(dateTimeZone.convertUTCToLocal(date.getTime())));
            }
        }
    }
}

