/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.pathfinder;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.gpsmaster.ConnectivityType;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.pathfinder.RouteProvider;
import org.gpsmaster.pathfinder.Transport;
import org.gpsmaster.pathfinder.TransportType;

public class RouteProviderYOURS
extends RouteProvider {
    protected final Locale requestLocale = new Locale("en", "US");
    protected List<Transport> transports = null;

    @Override
    public String getName() {
        return "YOURS";
    }

    @Override
    public String getDescription() {
        return "http://www.yournavigation.org/";
    }

    @Override
    public String getAttribution() {
        return null;
    }

    @Override
    public long getMaxDistance() {
        return 0L;
    }

    @Override
    public ConnectivityType getConnectivityType() {
        return ConnectivityType.ONLINE;
    }

    @Override
    public List<Transport> getTransport() {
        if (this.transports == null) {
            this.transports = new ArrayList<Transport>();
            this.transports.add(new Transport("Foot", TransportType.FOOT, "v=foot"));
            Transport transport = new Transport("Bicycle", TransportType.BICYCLE, "v=bicycle");
            transport.setDescription("Bicycle. Use all allowed roads");
            this.transports.add(transport);
            Transport transport2 = new Transport("Bicycle (Routes)", TransportType.BICYCLE, "v=bicycle&layer=cn");
            transport2.setDescription("Bicycle. Only cycle route networks");
            this.transports.add(new Transport("Car", TransportType.CAR, "v=motorcar"));
        }
        return this.transports;
    }

    @Override
    public void findRoute(List<Waypoint> list, double d, double d2, double d3, double d4) throws Exception {
        if (this.transport == null) {
            throw new IllegalArgumentException("transport not set");
        }
        String string = this.getXMLResponse(d, d2, d3, d4);
        List<Waypoint> list2 = this.parseXML(string);
        list.addAll(list2);
    }

    public String getXMLResponse(double d, double d2, double d3, double d4) throws Exception {
        String string = "http://www.yournavigation.org/api/1.0/gosmore.php?format=kml&" + String.format(this.requestLocale, "flat=%.6f&flon=%.6f", d, d2) + "&" + String.format(this.requestLocale, "tlat=%.6f&tlon=%.6f", d3, d4) + "&" + this.transport.urlParam + "&fast=0";
        String string2 = "UTF-8";
        URLConnection uRLConnection = null;
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        StringBuilder stringBuilder = new StringBuilder();
        uRLConnection = new URL(string).openConnection();
        uRLConnection.setRequestProperty("Accept-Charset", string2);
        uRLConnection.setRequestProperty("X-Yours-client", "www.gpsmaster.org");
        inputStream = uRLConnection.getInputStream();
        bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string2));
        String string3 = bufferedReader.readLine();
        while (string3 != null) {
            stringBuilder.append(string3);
            stringBuilder.append('\n');
            string3 = bufferedReader.readLine();
        }
        bufferedReader.close();
        return stringBuilder.toString();
    }

    protected List<Waypoint> parseXML(String string) throws Exception {
        ArrayList<Waypoint> arrayList = new ArrayList<Waypoint>();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        boolean bl = false;
        boolean bl2 = false;
        String string2 = "";
        double d = 0.0;
        double d2 = 0.0;
        try {
            XMLStreamReader xMLStreamReader = xMLInputFactory.createXMLStreamReader(byteArrayInputStream, "ISO-8859-1");
            while (xMLStreamReader.hasNext()) {
                xMLStreamReader.next();
                if (xMLStreamReader.getEventType() == 1 && xMLStreamReader.getLocalName().equals("LineString")) {
                    bl = true;
                }
                if (xMLStreamReader.getEventType() == 2 && xMLStreamReader.getLocalName().equals("LineString")) {
                    bl = false;
                }
                if (bl) {
                    if (xMLStreamReader.getEventType() == 1 && xMLStreamReader.getLocalName().equals("coordinates")) {
                        bl2 = true;
                        xMLStreamReader.next();
                        if (xMLStreamReader.isCharacters()) {
                            string2 = string2 + xMLStreamReader.getText();
                            xMLStreamReader.next();
                        }
                    }
                    if (xMLStreamReader.getEventType() == 2 && xMLStreamReader.getLocalName().equals("coordinates")) {
                        bl2 = false;
                    }
                }
                if (!bl2 || !xMLStreamReader.isCharacters()) continue;
                string2 = string2 + xMLStreamReader.getText();
            }
            String[] stringArray = string2.split("\n");
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].contains(",")) continue;
                String[] stringArray2 = stringArray[i].split(",");
                d2 = Double.parseDouble(stringArray2[0]);
                d = Double.parseDouble(stringArray2[1]);
                Waypoint waypoint = new Waypoint(d, d2);
                arrayList.add(waypoint);
            }
            xMLStreamReader.close();
        }
        catch (Exception exception) {
            throw new Exception("There was a problem parsing the XML response.");
        }
        if (arrayList.size() > 0) {
            arrayList.remove(arrayList.get(0));
        }
        return arrayList;
    }
}

