/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.pathfinder;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.gpsmaster.ConnectivityType;
import org.gpsmaster.gpsloader.GpsLoader;
import org.gpsmaster.gpsloader.GpsLoaderFactory;
import org.gpsmaster.gpxpanel.GPXFile;
import org.gpsmaster.gpxpanel.Track;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.pathfinder.RouteProvider;
import org.gpsmaster.pathfinder.Transport;
import org.gpsmaster.pathfinder.TransportType;

public class RouteProviderGraphHopper
extends RouteProvider {
    protected final String FORMAT = "gpx";
    protected final Locale requestLocale = new Locale("en", "US");
    protected List<Transport> routeTypes = null;

    @Override
    public String getName() {
        return "GraphHopper";
    }

    @Override
    public String getDescription() {
        return "https://graphhopper.com/";
    }

    @Override
    public String getAttribution() {
        return "Powered by <a href=\"https://graphhopper.com/#directions-api\">GraphHopper API</a>";
    }

    @Override
    public long getMaxDistance() {
        return 400L;
    }

    @Override
    public List<Transport> getTransport() {
        if (this.routeTypes == null) {
            this.routeTypes = new ArrayList<Transport>();
            this.routeTypes.add(new Transport("Foot", TransportType.FOOT, "vehicle=foot"));
            this.routeTypes.add(new Transport("Bicycle", TransportType.BICYCLE, "vehicle=bike"));
            this.routeTypes.add(new Transport("Car", TransportType.FOOT, "vehicle=car"));
        }
        return this.routeTypes;
    }

    @Override
    public void findRoute(List<Waypoint> list, double d, double d2, double d3, double d4) throws Exception {
        String string = "https://graphhopper.com/api/1/route?key=84c6481b-ab01-4307-93e1-925c67145a62&point=" + String.format(this.requestLocale, "%.6f,%.6f", d, d2) + "&point=" + String.format(this.requestLocale, "%.6f,%.6f", d3, d4) + "&" + this.transport.urlParam + "&instructions=false&calc_points=true&type=" + "gpx";
        String string2 = "UTF-8";
        URLConnection uRLConnection = null;
        InputStream inputStream = null;
        uRLConnection = new URL(string).openConnection();
        uRLConnection.setRequestProperty("Accept-Charset", string2);
        GpsLoader gpsLoader = GpsLoaderFactory.getLoaderByExtension("gpx");
        inputStream = uRLConnection.getInputStream();
        GPXFile gPXFile = gpsLoader.load(inputStream, "gpx");
        inputStream.close();
        if (gPXFile.getTracks().size() != 1) {
            throw new IllegalArgumentException("Invalid number of resulting tracks");
        }
        Track track = gPXFile.getTracks().get(0);
        if (track.getTracksegs().size() != 1) {
            throw new IllegalArgumentException("Invalid number of track segments");
        }
        list.addAll(track.getTracksegs().get(0).getWaypoints());
    }

    @Override
    public ConnectivityType getConnectivityType() {
        return ConnectivityType.ONLINE;
    }
}

