/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.painter;

import java.awt.Graphics2D;
import java.awt.Point;
import java.util.List;
import org.gpsmaster.gpxpanel.GPXFile;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.gpxpanel.WaypointGroup;
import org.gpsmaster.marker.Marker;
import org.gpsmaster.painter.Painter;
import org.openstreetmap.gui.jmapviewer.JMapViewer;

public class WaypointPainter
extends Painter {
    private final int ORDER = 5;

    public WaypointPainter() {
        this.order = 5;
    }

    public WaypointPainter(JMapViewer jMapViewer) {
        super(jMapViewer);
        this.order = 5;
    }

    @Override
    public void paint(Graphics2D graphics2D, GPXFile gPXFile) {
        WaypointGroup waypointGroup = gPXFile.getWaypointGroup();
        if (gPXFile.isVisible() && waypointGroup.isVisible()) {
            for (Waypoint waypoint : waypointGroup.getWaypoints()) {
                this.paintMarker(graphics2D, (Marker)waypoint);
            }
        }
    }

    @Override
    public void paint(Graphics2D graphics2D, List<Marker> list) {
        for (Marker marker : list) {
            this.paintMarker(graphics2D, marker);
        }
    }

    private void paintMarker(Graphics2D graphics2D, Marker marker) {
        Point point = this.mapViewer.getMapPosition(marker.getLat(), marker.getLon(), false);
        graphics2D.drawOval(point.x - 2, point.y - 2, 4, 4);
        marker.paint(graphics2D, point);
    }
}

