/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.painter;

import eu.fuegenstein.unit.UnitConverter;
import eu.fuegenstein.util.XTime;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.gpsmaster.gpxpanel.GPXFile;
import org.gpsmaster.gpxpanel.ProgressType;
import org.gpsmaster.gpxpanel.Route;
import org.gpsmaster.gpxpanel.Track;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.gpxpanel.WaypointGroup;
import org.gpsmaster.marker.Marker;
import org.gpsmaster.painter.Painter;

public class ProgressPainter
extends Painter {
    private double multiplier = 2.7f;
    private double labelDistance = 0.0;
    private double distanceInterval = 0.0;
    private long timeInterval = 0L;
    private UnitConverter uc = null;
    private ProgressType progressType = ProgressType.NONE;

    public ProgressPainter(UnitConverter unitConverter) {
        this.uc = unitConverter;
    }

    public ProgressType getProgressType() {
        return this.progressType;
    }

    public void setProgressType(ProgressType progressType) {
        this.progressType = progressType;
    }

    public double getDistanceInterval() {
        return this.distanceInterval;
    }

    public void setDistanceInterval(double d) {
        this.distanceInterval = d;
    }

    public long getTimeInterval() {
        return this.timeInterval;
    }

    public void setTimeInterval(long l) {
        this.timeInterval = l;
    }

    @Override
    public void paint(Graphics2D graphics2D, GPXFile gPXFile) {
        if (this.distanceInterval != 0.0) {
            this.labelDistance = this.distanceInterval;
        }
        if (this.progressType != ProgressType.NONE && this.enabled && gPXFile.isVisible()) {
            for (Track gPXObjectCommon : gPXFile.getTracks()) {
                for (WaypointGroup waypointGroup : gPXObjectCommon.getTracksegs()) {
                    if (!waypointGroup.isVisible() || waypointGroup.getNumPts() <= 2) continue;
                    this.paintSegment(graphics2D, waypointGroup);
                }
            }
            for (Route route : gPXFile.getRoutes()) {
                if (!route.getPath().isVisible() || route.getNumPts() <= 2) continue;
                this.paintSegment(graphics2D, route.getPath());
            }
        }
        this.coordinator.setDistanceInterval(this.labelDistance);
    }

    @Override
    public void paint(Graphics2D graphics2D, List<Marker> list) {
    }

    private void paintSegment(Graphics2D graphics2D, WaypointGroup waypointGroup) {
        double d = 0.0;
        double d2 = 0.0;
        graphics2D.setColor(Color.BLACK);
        Waypoint waypoint = waypointGroup.getStart();
        this.paintLabel(graphics2D, waypointGroup.getStart(), waypointGroup.getStart(), d);
        for (Waypoint waypoint2 : waypointGroup.getWaypoints()) {
            double d3;
            if (d2 >= this.labelDistance) {
                this.paintLabel(graphics2D, waypoint2, waypointGroup.getStart(), d);
                d2 = 0.0;
            }
            if (!Double.isNaN(d3 = waypoint2.getDistance(waypoint))) {
                d += d3;
                d2 += d3;
            }
            waypoint = waypoint2;
        }
        this.paintLabel(graphics2D, waypointGroup.getEnd(), waypointGroup.getStart(), d);
    }

    private void paintLabel(Graphics2D graphics2D, Waypoint waypoint, Waypoint waypoint2, double d) {
        String string = "";
        if (waypoint == null) {
            System.out.println("NULL wpt");
        }
        Point point = this.mapViewer.getMapPosition(waypoint.getLat(), waypoint.getLon(), false);
        switch (this.progressType) {
            case ABSOLUTE: {
                if (waypoint.getTime() == null) {
                    string = "--:--:--";
                    break;
                }
                string = String.format("%tT", waypoint.getTime());
                break;
            }
            case RELATIVE: {
                long l = waypoint2.getDuration(waypoint);
                string = XTime.getDurationString(l);
                break;
            }
        }
        String string2 = this.uc.dist(d, "%.2f");
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Rectangle2D rectangle2D = null;
        rectangle2D = string.length() > string2.length() ? fontMetrics.getStringBounds(string, graphics2D) : fontMetrics.getStringBounds(string2, graphics2D);
        graphics2D.setColor(new Color(255, 255, 255, 155));
        graphics2D.fillRoundRect(point.x - 3, point.y - (int)rectangle2D.getHeight() - 3, (int)rectangle2D.getWidth() + 6, (int)(rectangle2D.getHeight() + 4.0) * 2 - 1, 5, 5);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawString(string, point.x, point.y - 1);
        graphics2D.drawString(string2, point.x, point.y + (int)rectangle2D.getHeight());
        if (this.distanceInterval == 0.0) {
            this.labelDistance = this.mapViewer.getMeterPerPixel() * (double)((int)rectangle2D.getWidth() + 6) * this.multiplier;
        }
    }
}

