/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.osm;

import eu.fuegenstein.gis.GeoBounds;
import java.util.HashMap;
import java.util.Map;

public class OsmQuery {
    public static final int NODE = 0;
    public static final int WAY = 1;
    public static final int RELATION = 2;
    private boolean useRegExp = false;
    private boolean caseSensitive = false;
    private int type = 0;
    private int radius = 0;
    private GeoBounds bounds = null;
    private Map<String, String> tags = new HashMap<String, String>();

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int n) {
        this.radius = n;
    }

    public GeoBounds getGeoBounds() {
        return this.bounds;
    }

    public void setGeoBounds(GeoBounds geoBounds) {
        this.bounds = geoBounds;
    }

    public void addTag(String string, String string2) {
        this.tags.put(string, string2);
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> map) {
        this.tags = map;
    }

    public boolean isUseRegExp() {
        return this.useRegExp;
    }

    public void setUseRegExp(boolean bl) {
        this.useRegExp = bl;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean bl) {
        this.caseSensitive = bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<query type=\"");
        switch (this.type) {
            case 0: {
                stringBuilder.append("node");
                break;
            }
            case 1: {
                stringBuilder.append("way");
                break;
            }
            case 2: {
                stringBuilder.append("relation");
            }
        }
        stringBuilder.append("\">");
        if (this.radius > 0) {
            stringBuilder.append(String.format("<around radius=\"%d\"/>", this.radius));
        }
        for (String string : this.tags.keySet()) {
            stringBuilder.append("<has-kv k=\"" + string + "\" ");
            String string2 = "";
            if (this.useRegExp || this.caseSensitive) {
                stringBuilder.append("regv=");
            } else {
                stringBuilder.append("v=");
            }
            if (this.caseSensitive) {
                for (char c : this.tags.get(string).toCharArray()) {
                    string2 = string2 + "[" + c + "]";
                }
            } else {
                string2 = this.tags.get(string);
            }
            stringBuilder.append("\"" + string2 + "\"/>");
        }
        if (this.bounds != null) {
            stringBuilder.append(String.format("<bbox-query e=\"%.4f\" n=\"%.4f\" s=\"%.4f\" w=\"%.4f\"/>", this.bounds.getE(), this.bounds.getN(), this.bounds.getS(), this.bounds.getW()));
        }
        stringBuilder.append("</query>");
        return stringBuilder.toString();
    }
}

