/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.osm;

import com.topografix.gpx._1._1.LinkType;
import eu.fuegenstein.messagecenter.MessageCenter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.gpsmaster.gpxpanel.GPXFile;
import org.gpsmaster.gpxpanel.GPXObject;
import org.gpsmaster.gpxpanel.GPXObjectND;
import org.gpsmaster.gpxpanel.Track;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.gpxpanel.WaypointGroup;
import org.gpsmaster.osm.OsmQuery;
import se.kodapan.osm.domain.Node;
import se.kodapan.osm.domain.OsmObject;
import se.kodapan.osm.domain.Relation;
import se.kodapan.osm.domain.RelationMembership;
import se.kodapan.osm.domain.Way;
import se.kodapan.osm.domain.root.PojoRoot;
import se.kodapan.osm.parser.xml.OsmXmlParserException;
import se.kodapan.osm.services.overpass.Overpass;
import se.kodapan.osm.services.overpass.OverpassException;
import se.kodapan.osm.services.overpass.OverpassUtils;

public class Osm {
    private Overpass overpass = null;
    private OverpassUtils overpassUtils = null;
    private List<OsmQuery> queries = new ArrayList<OsmQuery>();
    private MessageCenter msg = null;
    private final String[] nameKeys = new String[]{"name", "alt_name", "ref", "operator"};

    public Osm(MessageCenter messageCenter) {
        this.msg = messageCenter;
    }

    public MessageCenter getMessageCenter() {
        return this.msg;
    }

    public void setMessageCenter(MessageCenter messageCenter) {
        this.msg = messageCenter;
    }

    public void findRelations() {
    }

    public void downloadRelation(long l, GPXFile gPXFile) throws Exception {
        if (gPXFile.getMetadata().getName().isEmpty()) {
            gPXFile.getMetadata().setName("OSM Download");
        }
        gPXFile.getMetadata().getCopyright().setLicense("CC-BY-SA");
        gPXFile.getMetadata().getCopyright().setAuthor("OpenStreetMap Contributors");
        this.overpass = new Overpass();
        this.overpass.open();
        this.overpass.setUserAgent(this.getClass().getCanonicalName());
        this.overpassUtils = new OverpassUtils(this.overpass);
        Relation relation = this.overpassUtils.loadRelation(l);
        this.overpass.close();
        this.relationToGpx(relation, gPXFile);
    }

    public void addQuery(OsmQuery osmQuery) {
        this.queries.add(osmQuery);
    }

    public void setQueries(List<OsmQuery> list) {
        this.queries = list;
    }

    public List<OsmQuery> getQueries() {
        return this.queries;
    }

    public PojoRoot runQuery() throws OverpassException, OsmXmlParserException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<osm-script>");
        for (OsmQuery osmQuery : this.queries) {
            stringBuilder.append(osmQuery.toString());
        }
        stringBuilder.append("<print/></osm-script>");
        this.overpass = new Overpass();
        try {
            this.overpass.open();
            this.overpass.setUserAgent(this.getClass().getCanonicalName());
            this.overpassUtils = new OverpassUtils(this.overpass);
            return this.overpassUtils.runQuery(stringBuilder.toString());
        }
        catch (Exception exception) {
            throw new OverpassException();
        }
    }

    private void wayToSegment(Way way, WaypointGroup waypointGroup) {
        for (Node node : way.getNodes()) {
            Waypoint waypoint = new Waypoint(node.getLatitude(), node.getLongitude());
            waypointGroup.addWaypoint(waypoint);
        }
    }

    private Way getNeighbour(Way way, Node node, List<Way> list) {
        for (Way way2 : list) {
            if (way2.equals(way) || !way2.getFirst().equals(node) && !way2.getLast().equals(node)) continue;
            return way2;
        }
        return null;
    }

    private void continueWay(Way way, Node node, List<Way> list) {
        Way way2 = this.getNeighbour(way, node, list);
        while (way2 != null) {
            if (way.getFirst().equals(node)) {
                if (way2.getFirst().equals(node)) {
                    way2.reverse();
                }
                way2.getNodes().remove(node);
                way.addBefore(way2);
                node = way.getFirst();
            } else if (way.getLast().equals(node)) {
                if (way2.getLast().equals(node)) {
                    way2.reverse();
                }
                way2.getNodes().remove(node);
                way.addAfter(way2);
                node = way.getLast();
            }
            list.remove(way2);
            way2 = this.getNeighbour(way, node, list);
        }
    }

    public void relationToGpx(Relation relation, GPXFile gPXFile) {
        Object object;
        if (relation == null) {
            this.msg.volatileError("Relation not found");
            return;
        }
        ArrayList<Way> arrayList = new ArrayList<Way>();
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        if (relation.getMembers() != null) {
            OsmObject osmObject;
            for (RelationMembership serializable : relation.getMembers()) {
                if (!(serializable.getObject() instanceof Relation) || arrayList2.contains((osmObject = (Relation)serializable.getObject()).getId())) continue;
                try {
                    osmObject = this.overpassUtils.loadRelation(osmObject.getId());
                    osmObject.setLoaded(true);
                    this.relationToGpx((Relation)osmObject, gPXFile);
                    arrayList2.add(osmObject.getId());
                }
                catch (OverpassException overpassException) {
                    this.msg.error(String.format("failed to download subrelation %d", osmObject.getId()), overpassException);
                }
                catch (OsmXmlParserException osmXmlParserException) {
                    this.msg.error(String.format("failed to parse subrelation %d", osmObject.getId()), osmXmlParserException);
                }
            }
            for (RelationMembership relationMembership : relation.getMembers()) {
                if (!(relationMembership.getObject() instanceof Way) || arrayList.contains(osmObject = (Way)relationMembership.getObject())) continue;
                arrayList.add((Way)osmObject);
            }
        }
        if (arrayList.size() > 0) {
            object = new Track(gPXFile.getColor());
            ((GPXObjectND)object).setName(this.getRelationName(relation));
            ((GPXObjectND)object).setDesc(String.format("OSM Relation (%d)", relation.getId()));
            while (arrayList.size() > 0) {
                Way way = (Way)arrayList.get(0);
                arrayList.remove(way);
                this.continueWay(way, way.getFirst(), arrayList);
                int n = way.getNodes().size();
                Node node = way.getNodes().get(n - 1);
                this.continueWay(way, node, arrayList);
                WaypointGroup waypointGroup = new WaypointGroup(((GPXObject)object).getColor(), WaypointGroup.WptGrpType.TRACKSEG);
                this.wayToSegment(way, waypointGroup);
                ((Track)object).addTrackseg(waypointGroup);
            }
            if (((Track)object).getTracksegs().size() > 0) {
                gPXFile.addTrack((Track)object);
            }
        }
        if (relation.getTags().containsKey("website")) {
            object = new LinkType();
            ((LinkType)object).setHref(relation.getTag("website"));
            gPXFile.getMetadata().getLink().add((LinkType)object);
        }
    }

    private String getRelationName(Relation relation) {
        String string = this.getName(relation);
        if (string.isEmpty()) {
            string = String.format("Relation %d (v%d)", relation.getId(), relation.getVersion());
        }
        return string;
    }

    private String getName(OsmObject osmObject) {
        String string = "name:".concat(Locale.getDefault().getLanguage());
        Map<String, String> map = osmObject.getTags();
        if (map.containsKey(string)) {
            return map.get(string);
        }
        for (String string2 : this.nameKeys) {
            if (!map.containsKey(string2)) continue;
            return map.get(string2);
        }
        return "";
    }
}

