/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.online;

import com.topografix.gpx._1._1.LinkType;
import eu.fuegenstein.messagecenter.MessageCenter;
import eu.fuegenstein.unit.UnitConverter;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.SwingWorker;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.gpsmaster.GpsMaster;
import org.gpsmaster.dialogs.DistanceRenderer;
import org.gpsmaster.dialogs.GenericDownloadDialog;
import org.gpsmaster.filehub.DataType;
import org.gpsmaster.filehub.FileHub;
import org.gpsmaster.filehub.TransferableItem;
import org.gpsmaster.gpxpanel.GPXFile;
import org.gpsmaster.marker.WikiMarker;
import org.gpsmaster.online.OnlineTrack;
import org.gpsmaster.online.WikiTableModel;
import org.gpsmaster.online.WikiXmlHandler;
import org.xml.sax.helpers.DefaultHandler;

public class GetWikipedia
extends GenericDownloadDialog {
    private static final long serialVersionUID = 3863016323284963978L;
    private static final int MAX_RESULTS = 40;
    private static final int MAX_DISTANCE = 15;
    private static final String GEONAMES_USERNAME = "rfuegen";
    private GPXFile gpx = new GPXFile("Wikipedia");
    private final List<TransferableItem> items = Collections.synchronizedList(new ArrayList());

    public GetWikipedia(JFrame jFrame, MessageCenter messageCenter, FileHub fileHub, UnitConverter unitConverter) {
        super(jFrame, messageCenter, fileHub, unitConverter);
        this.setIcon("/org/gpsmaster/icons/downloadbar/", "wiki-down.png");
        this.items.add(new OnlineTrack());
    }

    public String getNameKey() {
        return "function.getwikipedia";
    }

    @Override
    public String getTitle() {
        return "Get nearby Wikipedia articles";
    }

    private void submitSearch(double d, double d2, String string) {
        Object object;
        String string2 = "http://api.geonames.org/findNearbyWikipedia?lat=" + d + "&lng=" + d2 + "&maxRows=" + 40 + "&radius=" + 15 + "&lang=" + string + "&username=" + GEONAMES_USERNAME;
        WikiXmlHandler wikiXmlHandler = new WikiXmlHandler((WikiTableModel)this.trackListModel);
        InputStream inputStream = null;
        try {
            object = new URL(string2);
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            inputStream = ((URL)object).openStream();
            sAXParser.parse(inputStream, (DefaultHandler)wikiXmlHandler);
        }
        catch (Exception exception) {
            this.msg.error(exception);
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.trackListModel.isEmpty() && (object = wikiXmlHandler.getErrorMessage()) != null && !((String)object).equals("")) {
            this.msg.volatileError((String)object);
        }
    }

    @Override
    protected void loadSelected() {
        int n = this.trackTable.getSelectedRowCount();
        if (n > 0) {
            int[] nArray = this.trackTable.getSelectedRows();
            for (int i = 0; i < n; ++i) {
                OnlineTrack onlineTrack;
                String string;
                String[] stringArray;
                int n2 = nArray[i];
                if (n2 < 0 || n2 >= this.trackListModel.getRowCount() || (stringArray = (string = (onlineTrack = (OnlineTrack)this.trackListModel.getItem(n2)).getDownloadLink()).split(",")).length != 2) continue;
                WikiMarker wikiMarker = new WikiMarker(Double.parseDouble(stringArray[0]), Double.parseDouble(stringArray[1]));
                wikiMarker.setName(onlineTrack.getName());
                LinkType linkType = new LinkType();
                linkType.setType("Wikipedia");
                linkType.setText(onlineTrack.getName());
                linkType.setHref(onlineTrack.getWebUrl());
                wikiMarker.setDesc(onlineTrack.getDescription());
                wikiMarker.getLink().add(linkType);
                this.gpx.getWaypointGroup().addWaypoint(wikiMarker);
            }
        }
        this.trackTable.clearSelection();
        this.fileHub.run();
        GpsMaster.active.refresh();
    }

    protected void downloadArticleList() {
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                GetWikipedia.this.msgPanel = GetWikipedia.this.msg.infoOn("Retrieving list of nearby Wikipedia articles ...");
                GetWikipedia.this.busyOn();
                double d = (GetWikipedia.this.bounds.getN() + GetWikipedia.this.bounds.getS()) / 2.0;
                double d2 = (GetWikipedia.this.bounds.getE() + GetWikipedia.this.bounds.getW()) / 2.0;
                String string = Locale.getDefault().getLanguage();
                GetWikipedia.this.submitSearch(d, d2, string);
                if (GetWikipedia.this.trackListModel.isEmpty() && GetWikipedia.this.errorMessage == null && string.equals("als")) {
                    GetWikipedia.this.submitSearch(d, d2, "de");
                }
                if (GetWikipedia.this.trackListModel.isEmpty() && GetWikipedia.this.errorMessage == null && !string.equals("en")) {
                    GetWikipedia.this.submitSearch(d, d2, "en");
                }
                if (GetWikipedia.this.errorMessage == null && GetWikipedia.this.trackListModel.isEmpty()) {
                    GetWikipedia.this.msg.warning("No Wikipedia articles found in perimeter.");
                }
                if (GetWikipedia.this.errorMessage != null) {
                    GetWikipedia.this.msg.volatileError(GetWikipedia.this.errorMessage);
                }
                return null;
            }

            @Override
            protected void done() {
                GetWikipedia.this.msg.infoOff(GetWikipedia.this.msgPanel);
                GetWikipedia.this.busyOff();
            }
        };
        swingWorker.execute();
    }

    @Override
    public boolean doShowProgressText() {
        return false;
    }

    @Override
    public DataType getDataType() {
        return DataType.GPXFILE;
    }

    @Override
    public List<TransferableItem> getItems() {
        return this.items;
    }

    @Override
    public GPXFile getGpxFile(TransferableItem transferableItem) {
        this.items.clear();
        return this.gpx;
    }

    @Override
    public void open(TransferableItem transferableItem) {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getInputStream() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void setupTableModel() {
        this.trackListModel = new WikiTableModel(this.uc);
    }

    @Override
    protected void setupTable() {
        this.trackTable.getColumnModel().getColumn(0).setPreferredWidth(300);
        this.trackTable.getColumnModel().getColumn(1).setPreferredWidth(80);
        DistanceRenderer distanceRenderer = new DistanceRenderer(this.uc);
        this.trackTable.getColumnModel().getColumn(1).setCellRenderer(distanceRenderer);
    }

    @Override
    public void begin() {
        this.descPanel.setVisible(true);
        this.downloadArticleList();
    }

    @Override
    protected String getColumnKey(int n) {
        return "---";
    }
}

