/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.online;

import eu.fuegenstein.messagecenter.MessageCenter;
import eu.fuegenstein.unit.UnitConverter;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.SwingWorker;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.gpsmaster.dialogs.DistanceRenderer;
import org.gpsmaster.dialogs.GenericDownloadDialog;
import org.gpsmaster.filehub.DataType;
import org.gpsmaster.filehub.FileHub;
import org.gpsmaster.filehub.TransferableItem;
import org.gpsmaster.gpxpanel.GPXFile;
import org.gpsmaster.online.GpsiesTableModel;
import org.gpsmaster.online.GpsiesXmlHandler;
import org.gpsmaster.online.OnlineTrack;
import org.xml.sax.helpers.DefaultHandler;

public class DownloadGpsies
extends GenericDownloadDialog {
    private static final long serialVersionUID = 7062740464390862897L;
    private static final int RESULTS_PER_PAGE = 20;
    private static final int INITIAL_PAGES = 3;
    private int currPage = 1;
    private TransferableItem currentItem = null;
    private InputStream inStream = null;
    private final List<TransferableItem> items = Collections.synchronizedList(new ArrayList());

    public DownloadGpsies(JFrame jFrame, MessageCenter messageCenter, FileHub fileHub, UnitConverter unitConverter) {
        super(jFrame, messageCenter, fileHub, unitConverter);
        this.setIcon("/org/gpsmaster/icons/downloadbar/", "gpsies-down.png");
    }

    public String getNameKey() {
        return "function.getgpsies";
    }

    @Override
    protected String getColumnKey(int n) {
        if (n == 0) {
            return "Track Name";
        }
        return "Distance";
    }

    public void downloadTrackList(int n) {
        URL uRL = null;
        InputStream inputStream = null;
        String string = "http://ws.gpsies.com/api.do?BBOX=" + this.bounds.getW() + "," + this.bounds.getS() + "," + this.bounds.getE() + "," + this.bounds.getN() + "&limit=" + 20 + "&resultPage=" + n + "&key=" + "wbqmlgbborqsbtqx" + "&filetype=gpxTrk";
        GpsiesXmlHandler gpsiesXmlHandler = new GpsiesXmlHandler((GpsiesTableModel)this.trackListModel);
        try {
            uRL = new URL(string);
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setRequestProperty("User-Agent", "GpsMaster 0.63.31");
            inputStream = uRLConnection.getInputStream();
            sAXParser.parse(inputStream, (DefaultHandler)gpsiesXmlHandler);
        }
        catch (Exception exception) {
            this.msg.error(exception);
            exception.printStackTrace();
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void begin() {
        this.descPanel.setVisible(true);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                DownloadGpsies.this.busyOn();
                DownloadGpsies.this.msgPanel = DownloadGpsies.this.msg.infoOn("Retrieving list of tracks for current map view ...");
                do {
                    DownloadGpsies.this.downloadTrackList(DownloadGpsies.this.currPage);
                    DownloadGpsies.this.currPage++;
                } while (DownloadGpsies.this.currPage <= 3 && DownloadGpsies.this.trackListModel.getRowCount() % 20 == 0);
                return null;
            }

            @Override
            protected void done() {
                DownloadGpsies.this.trackTable.minimizeColumnWidth(0, 1);
                DownloadGpsies.this.trackTable.minimizeColumnWidth(2, 1);
                DownloadGpsies.this.trackTable.minimizeColumnWidth(3, 1);
                if (DownloadGpsies.this.trackListModel.getRowCount() == 0) {
                    DownloadGpsies.this.msg.volatileWarning("No tracks found.");
                } else {
                    DownloadGpsies.this.msg.volatileInfo(DownloadGpsies.this.trackListModel.getRowCount() + " Tracks found.");
                }
                DownloadGpsies.this.msg.infoOff(DownloadGpsies.this.msgPanel);
                DownloadGpsies.this.busyOff();
            }
        };
        swingWorker.execute();
    }

    @Override
    protected void loadSelected() {
        int n = this.trackTable.getSelectedRowCount();
        if (n > 0) {
            int[] nArray = this.trackTable.getSelectedRows();
            for (int i = 0; i < n; ++i) {
                int n2 = this.trackTable.convertRowIndexToModel(nArray[i]);
                if (n2 < 0 || n2 >= this.trackListModel.getRowCount()) continue;
                TransferableItem transferableItem = this.trackListModel.getItem(n2);
                transferableItem.setTransferState(1);
                transferableItem.setSourceFormat("gpx");
                this.items.add(transferableItem);
            }
            this.trackTable.clearSelection();
            this.fileHub.run();
        }
    }

    @Override
    public String getName() {
        return "gpsies.com";
    }

    @Override
    public DataType getDataType() {
        return DataType.STREAM;
    }

    @Override
    public String getTitle() {
        return "Download Tracks from Gpsies.com";
    }

    @Override
    public boolean doShowProgressText() {
        return true;
    }

    @Override
    public List<TransferableItem> getItems() {
        return this.items;
    }

    @Override
    public GPXFile getGpxFile(TransferableItem transferableItem) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void open(TransferableItem transferableItem) {
        this.currentItem = transferableItem;
    }

    @Override
    public InputStream getInputStream() throws Exception {
        if (this.currentItem != null) {
            OnlineTrack onlineTrack = (OnlineTrack)this.currentItem;
            String string = onlineTrack.getDownloadLink();
            URLConnection uRLConnection = new URL(string).openConnection();
            this.inStream = uRLConnection.getInputStream();
        }
        return this.inStream;
    }

    @Override
    public void close() throws Exception {
        this.currentItem = null;
        if (this.inStream != null) {
            this.inStream.close();
        }
        Thread.sleep(2000L);
    }

    @Override
    protected void setupTableModel() {
        this.trackListModel = new GpsiesTableModel(this.uc);
    }

    @Override
    protected void setupTable() {
        this.trackTable.getColumnModel().getColumn(0).setPreferredWidth(20);
        this.trackTable.getColumnModel().getColumn(2).setPreferredWidth(80);
        DistanceRenderer distanceRenderer = new DistanceRenderer(this.uc);
        this.trackTable.getColumnModel().getColumn(2).setCellRenderer(distanceRenderer);
    }
}

