/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.marker;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.Enumeration;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.tree.TreeNode;
import org.gpsmaster.GpsMaster;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.marker.IMarkerCallback;

public class Marker
extends Waypoint
implements TreeNode {
    protected ImageIcon icon = null;
    protected ImageIcon webIcon = null;
    protected Color foregroundColor = Color.BLACK;
    protected Color backgroundColor = new Color(255, 255, 255, 192);
    protected Font font = null;
    protected Point iconLocation = new Point();
    private Rectangle iconBounds = new Rectangle();
    private Rectangle labelBounds = new Rectangle();
    protected JLabel label = new JLabel();
    protected boolean drawBounds = false;
    private boolean isSelected = false;
    protected IMarkerCallback callback = null;
    protected int offset = -2;
    public static final int POSITION_ABOVE = 1;
    public static final int POSITION_BELOW = 2;
    public static final int POSITION_LEFT = 3;
    public static final int POSITION_RIGHT = 4;
    public static final int POSITION_CENTER = 5;
    protected final String iconPath = "/org/gpsmaster/icons/marker/";
    protected int labelPosition = 2;
    protected int markerPosition = 1;
    protected boolean showWebIcon = false;
    protected int iconXOffset = 0;
    protected int iconYOffset = 0;

    public Marker(double d, double d2) {
        super(d, d2);
        this.setup();
        this.setType();
    }

    public Marker(Waypoint waypoint) {
        super(waypoint);
        this.setup();
        this.setType();
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public void setIcon(ImageIcon imageIcon) {
        this.icon = imageIcon;
        this.iconBounds.width = imageIcon.getIconWidth();
        this.iconBounds.height = imageIcon.getIconHeight();
    }

    public void setIcon(String string) {
        this.icon = new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/marker/".concat(string)));
        this.iconBounds.width = this.icon.getIconWidth();
        this.iconBounds.height = this.icon.getIconHeight();
    }

    public Color getForeground() {
        return this.foregroundColor;
    }

    public void setForeground(Color color) {
        this.foregroundColor = color;
    }

    public Color getBackground() {
        return this.backgroundColor;
    }

    public void setBackground(Color color) {
        this.backgroundColor = color;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean bl) {
        this.isSelected = bl;
    }

    public int getMarkerPosition() {
        return this.markerPosition;
    }

    public void setMarkerPosition(int n) {
        this.markerPosition = n;
    }

    public int getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelPosition(int n) {
        this.labelPosition = n;
    }

    public void setCallback(IMarkerCallback iMarkerCallback) {
        this.callback = iMarkerCallback;
    }

    public IMarkerCallback getCallback() {
        return this.callback;
    }

    public void Callback(MouseEvent mouseEvent) {
        if (this.callback != null) {
            this.callback.Callback(this, mouseEvent);
        }
    }

    public boolean contains(Point point) {
        if (point != null) {
            return this.iconBounds.contains(point) || this.labelBounds.contains(point);
        }
        return false;
    }

    public void paint(Graphics2D graphics2D, Point point) {
        if (this.icon != null) {
            this.paintIcon(graphics2D, point);
            if (this.links != null && this.links.size() > 0 && this.showWebIcon) {
                this.paintWebIcon(graphics2D, point);
            }
        }
        if (!this.name.isEmpty()) {
            this.paintLabel(graphics2D, point);
        }
        if ((this.drawBounds || this.isSelected()) && this.icon != null) {
            graphics2D.drawRect(this.iconBounds.x, this.iconBounds.y, this.iconBounds.width, this.iconBounds.height);
        }
    }

    private void paintWebIcon(Graphics2D graphics2D, Point point) {
        if (this.webIcon == null) {
            this.webIcon = new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/marker/".concat("link-small.png")));
        }
        int n = this.iconBounds.x + this.iconBounds.width - this.webIcon.getIconWidth();
        int n2 = this.iconBounds.y + this.iconBounds.height - this.webIcon.getIconHeight();
        this.webIcon.paintIcon(null, graphics2D, n, n2);
    }

    private void paintLabel(Graphics2D graphics2D, Point point) {
        Point point2 = new Point();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Rectangle2D rectangle2D = null;
        rectangle2D = fontMetrics.getStringBounds(this.name, graphics2D);
        switch (this.labelPosition) {
            default: 
        }
        point2.x = point.x - (int)(rectangle2D.getWidth() / 2.0);
        point2.y = point.y + 2;
        graphics2D.setColor(this.backgroundColor);
        graphics2D.fillRoundRect(point2.x - 2, point2.y - 2, (int)(rectangle2D.getWidth() + 4.0), (int)(rectangle2D.getHeight() + 4.0), 2, 2);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawString(this.name, point2.x, (int)((double)point2.y + rectangle2D.getHeight() - 1.0));
    }

    private void paintIcon(Graphics2D graphics2D, Point point) {
        switch (this.markerPosition) {
            case 5: {
                this.iconLocation.x = point.x - this.icon.getIconWidth() / 2;
                this.iconLocation.y = point.y - this.icon.getIconHeight() / 2;
                break;
            }
            case 4: {
                this.iconLocation.x = point.x + this.offset;
                this.iconLocation.y = point.y - this.icon.getIconHeight() / 2;
                break;
            }
            default: {
                this.iconLocation.x = point.x - this.icon.getIconWidth() / 2;
                this.iconLocation.y = point.y - this.icon.getIconHeight() + this.offset;
            }
        }
        this.iconLocation.x += this.iconXOffset;
        this.iconLocation.y += this.iconYOffset;
        this.icon.paintIcon(null, graphics2D, this.iconLocation.x, this.iconLocation.y);
        this.iconBounds.x = this.iconLocation.x;
        this.iconBounds.y = this.iconLocation.y;
    }

    protected void setup() {
    }

    private void setType() {
        this.getExtension().add("gpsm:marker", this.getClass().getName());
    }

    @Override
    public int compareTo(Marker marker) {
        if (this.getTime() == null || marker.getTime() == null) {
            return 0;
        }
        return this.getTime().compareTo(marker.getTime());
    }

    public Enumeration children() {
        return null;
    }

    @Override
    public boolean getAllowsChildren() {
        return false;
    }

    @Override
    public TreeNode getChildAt(int n) {
        return null;
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        return 0;
    }

    @Override
    public TreeNode getParent() {
        return null;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }
}

