/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.gpxpanel;

import eu.fuegenstein.gis.GeoBounds;
import eu.fuegenstein.messagecenter.MessageCenter;
import eu.fuegenstein.unit.UnitConverter;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import org.gpsmaster.GpsMaster;
import org.gpsmaster.gpxpanel.GPXFile;
import org.gpsmaster.gpxpanel.GPXObject;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.marker.Marker;
import org.gpsmaster.painter.PaintCoordinator;
import org.gpsmaster.painter.Painter;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.DefaultMapController;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.MemoryTileCache;
import org.openstreetmap.gui.jmapviewer.OsmMercator;
import org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource;

public class GPXPanel
extends JMapViewer {
    private List<GPXFile> gpxFiles;
    private Image imgCrosshair;
    private double crosshairLat;
    private double crosshairLon;
    private boolean showCrosshair = false;
    private boolean autoCenter = true;
    private Point shownPoint;
    private Color activeColor = Color.WHITE;
    private MouseAdapter mouseAdapter = null;
    private List<Marker> markerList;
    private List<Painter> painterList;
    private PaintCoordinator coordinator = new PaintCoordinator();

    public GPXPanel(UnitConverter unitConverter, MessageCenter messageCenter) {
        super(new MemoryTileCache());
        this.setTileSource(new OsmTileSource.Mapnik());
        DefaultMapController defaultMapController = new DefaultMapController(this);
        defaultMapController.setDoubleClickZoomEnabled(false);
        defaultMapController.setMovementEnabled(true);
        defaultMapController.setWheelZoomEnabled(true);
        defaultMapController.setMovementMouseButton(1);
        this.setScrollWrapEnabled(false);
        this.setZoomButtonStyle(JMapViewer.ZOOM_BUTTON_STYLE.VERTICAL);
        this.imgCrosshair = new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/crosshair-map.png")).getImage();
        this.markerList = new ArrayList<Marker>();
        this.painterList = new ArrayList<Painter>();
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                GPXPanel.this.checkMarkerClick(mouseEvent);
            }
        };
        this.addMouseListener(this.mouseAdapter);
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                GPXPanel.this.handleEvent(propertyChangeEvent);
            }
        };
        GpsMaster.active.addPropertyChangeListener(propertyChangeListener);
    }

    public void setGpxFiles(List<GPXFile> list) {
        this.gpxFiles = list;
    }

    public List<GPXFile> getGpxiles() {
        return this.gpxFiles;
    }

    public void addPainter(Painter painter) {
        painter.setMapViewer(this);
        painter.setCoordinator(this.coordinator);
        this.painterList.add(painter);
        Collections.sort(this.painterList);
    }

    public void removePainter(Painter painter) {
        this.painterList.remove(painter);
    }

    public void setCrosshairLat(double d) {
        this.crosshairLat = d;
    }

    public void setCrosshairLon(double d) {
        this.crosshairLon = d;
    }

    public void setShowCrosshair(boolean bl) {
        this.showCrosshair = bl;
    }

    public Point getShownPoint() {
        return this.shownPoint;
    }

    public void setShownPoint(Point point) {
        this.shownPoint = point;
    }

    private void setShownWaypoint(Waypoint waypoint, boolean bl) {
        Point point = null;
        if (waypoint != null && !this.contains(point = this.getMapPosition(waypoint.getLat(), waypoint.getLon(), false)) && bl) {
            this.setDisplayPosition(new Coordinate(waypoint.getLat(), waypoint.getLon()), this.getZoom());
        }
        this.shownPoint = point;
    }

    public Color getActiveColor() {
        return this.activeColor;
    }

    public void setActiveColor(Color color) {
        this.activeColor = color;
    }

    public List<Marker> getMarkerList() {
        return this.markerList;
    }

    public void addMarker(Marker marker) {
        if (!this.markerList.contains(marker)) {
            this.markerList.add(marker);
        }
    }

    public void removeMarker(Marker marker) {
        if (this.markerList.contains(marker)) {
            this.markerList.remove(marker);
        }
    }

    @Override
    protected synchronized void paintComponent(Graphics graphics) {
        Object object;
        super.paintComponent(graphics);
        if (this.activeColor == null) {
            this.activeColor = Color.GRAY;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        this.coordinator.clear();
        for (Painter painter : this.painterList) {
            for (GPXFile gPXFile : this.gpxFiles) {
                painter.paint(graphics2D, gPXFile);
            }
            painter.paint(graphics2D, this.markerList);
        }
        if (this.showCrosshair) {
            object = null;
            object = this.crosshairLon > -180.0 ? this.getMapPosition(new Coordinate(this.crosshairLat, this.crosshairLon), false) : this.getMapPosition(new Coordinate(this.crosshairLat, -180.0), false);
            int n = this.imgCrosshair.getWidth(null) / 2;
            graphics2D.drawImage(this.imgCrosshair, ((Point)object).x - n, ((Point)object).y - n, null);
        }
        if (this.shownPoint != null) {
            object = graphics2D.getStroke();
            Color color = graphics2D.getColor();
            graphics2D.setColor(Color.black);
            graphics2D.drawRect(this.shownPoint.x - 9, this.shownPoint.y - 9, 17, 17);
            graphics2D.setColor(Color.white);
            graphics2D.drawRect(this.shownPoint.x - 8, this.shownPoint.y - 8, 15, 15);
            graphics2D.setColor(Color.black);
            graphics2D.drawRect(this.shownPoint.x - 7, this.shownPoint.y - 7, 13, 13);
            int n = this.activeColor.getRed();
            int n2 = this.activeColor.getGreen();
            int n3 = this.activeColor.getBlue();
            AlphaComposite alphaComposite = AlphaComposite.SrcOver;
            graphics2D.setComposite(alphaComposite);
            graphics2D.setColor(new Color(255 - n, 255 - n2, 255 - n3, 160));
            graphics2D.fill(new Rectangle(this.shownPoint.x - 6, this.shownPoint.y - 6, 11, 11));
            graphics2D.setStroke((Stroke)object);
            graphics2D.setColor(color);
        }
    }

    private void checkMarkerClick(MouseEvent mouseEvent) {
        for (Marker treeNode : this.markerList) {
            if (!treeNode.contains(mouseEvent.getPoint())) continue;
            this.firePropertyChange(mouseEvent.getClickCount() + "click", null, treeNode);
            return;
        }
        for (GPXFile gPXFile : this.gpxFiles) {
            for (Waypoint waypoint : gPXFile.getWaypointGroup().getWaypoints()) {
                Marker marker = (Marker)waypoint;
                if (!marker.contains(mouseEvent.getPoint())) continue;
                this.firePropertyChange(mouseEvent.getClickCount() + "click", null, marker);
                return;
            }
        }
    }

    private void handleEvent(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("repaintMap")) {
            this.repaint();
        } else if (string.equals("activeTrkPt")) {
            this.setShownWaypoint(GpsMaster.active.getTrackpoint(), this.autoCenter);
            this.repaint();
        } else if (string.equals("activeWpt")) {
            this.setShownWaypoint(GpsMaster.active.getWaypoint(), this.autoCenter);
            this.repaint();
        } else if (string.equals("addMarker")) {
            Marker marker = (Marker)propertyChangeEvent.getNewValue();
            this.addMarker(marker);
        } else if (string.equals("removeMarker")) {
            Marker marker = (Marker)propertyChangeEvent.getNewValue();
            this.removeMarker(marker);
        } else if (string.equals("centerMap")) {
            Waypoint waypoint = (Waypoint)propertyChangeEvent.getNewValue();
            this.setDisplayPosition(new Coordinate(waypoint.getLat(), waypoint.getLon()), this.getZoom());
        }
    }

    public void fitGPXObjectToPanel(GPXObject gPXObject) {
        if (gPXObject != null) {
            int n = this.tileController.getTileSource().getMaxZoom();
            int n2 = (int)OsmMercator.MERCATOR_256.lonToX(gPXObject.getMinLon(), n);
            int n3 = (int)OsmMercator.MERCATOR_256.lonToX(gPXObject.getMaxLon(), n);
            int n4 = (int)OsmMercator.MERCATOR_256.latToY(gPXObject.getMaxLat(), n);
            int n5 = (int)OsmMercator.MERCATOR_256.latToY(gPXObject.getMinLat(), n);
            if (n2 <= n3 && n4 <= n5) {
                int n6;
                int n7 = Math.max(0, this.getWidth());
                int n8 = Math.max(0, this.getHeight());
                int n9 = n;
                int n10 = n3 - n2;
                for (n6 = n5 - n4; n10 > n7 || n6 > n8; n10 >>= 1, n6 >>= 1) {
                    --n9;
                }
                n10 = n2 + (n3 - n2) / 2;
                n6 = n4 + (n5 - n4) / 2;
                int n11 = 1 << n - n9;
                this.setDisplayPosition(n10 /= n11, n6 /= n11, n9);
            }
        }
    }

    public GeoBounds getVisibleBounds() {
        GeoBounds geoBounds = new GeoBounds();
        Point point = this.getCenter();
        geoBounds.setW(OsmMercator.MERCATOR_256.xToLon(point.x - this.getWidth() / 2, this.getZoom()));
        geoBounds.setN(OsmMercator.MERCATOR_256.yToLat(point.y - this.getHeight() / 2, this.getZoom()));
        geoBounds.setE(OsmMercator.MERCATOR_256.xToLon(point.x + this.getWidth() / 2, this.getZoom()));
        geoBounds.setS(OsmMercator.MERCATOR_256.yToLat(point.y + this.getHeight() / 2, this.getZoom()));
        return geoBounds;
    }
}

