/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.gpxpanel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;

public class GPXExtension
implements TreeNode {
    protected String key = null;
    protected String value = null;
    private String namespace = null;
    protected GPXExtension parent = null;
    protected List<GPXExtension> subs = new ArrayList<GPXExtension>();

    public GPXExtension() {
        this.key = "extensions";
    }

    public GPXExtension(String string) {
        this.key = string;
    }

    public GPXExtension(GPXExtension gPXExtension) {
        this.key = gPXExtension.key;
        this.value = gPXExtension.value;
        this.namespace = gPXExtension.namespace;
        for (GPXExtension gPXExtension2 : gPXExtension.getExtensions()) {
            this.subs.add(gPXExtension2);
        }
    }

    public GPXExtension(String string, String string2) {
        this.key = string;
        this.value = string2;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getSubValue(String string) {
        GPXExtension gPXExtension = this.getExtension(string);
        if (gPXExtension != null) {
            return gPXExtension.getValue();
        }
        return null;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String string) {
        this.namespace = string;
    }

    public void add(GPXExtension gPXExtension) {
        this.remove(gPXExtension.getKey());
        this.subs.add(gPXExtension);
    }

    public void add(String string, String string2) {
        this.add(new GPXExtension(string, string2));
    }

    public void remove(String string) {
        GPXExtension gPXExtension = this.getExtension(string);
        if (gPXExtension != null) {
            this.subs.remove(gPXExtension);
        }
    }

    public GPXExtension getExtension(String string) {
        for (GPXExtension gPXExtension : this.subs) {
            if (!gPXExtension.getKey().equals(string)) continue;
            return gPXExtension;
        }
        return null;
    }

    public boolean containsKey(String string) {
        return this.getExtension(string) != null;
    }

    public List<GPXExtension> getExtensions() {
        return this.subs;
    }

    public Enumeration<GPXExtension> children() {
        return Collections.enumeration(this.subs);
    }

    @Override
    public boolean getAllowsChildren() {
        return this.value == null;
    }

    @Override
    public TreeNode getChildAt(int n) {
        return this.subs.get(n);
    }

    @Override
    public int getChildCount() {
        return this.subs.size();
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        return this.subs.indexOf(treeNode);
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public boolean isLeaf() {
        return this.value != null;
    }

    public String toString() {
        return this.key + " " + this.value;
    }
}

