/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.gpsloader;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gpsmaster.gpsloader.XmlLoader;
import org.gpsmaster.gpxpanel.GPXFile;
import org.gpsmaster.gpxpanel.Track;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.gpxpanel.WaypointGroup;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TcxLoader
extends XmlLoader {
    private int currentLoadColor = 0;

    public TcxLoader() {
        this.isAdding = false;
        this.isDefault = false;
        this.extensions.add("tcx");
        this.xsdResource = "/org/gpsmaster/schema/TrainingCenterDatabasev2.xsd";
    }

    private Waypoint parseTrackPoint(Element element) {
        Element element2;
        Object object;
        Element element3;
        Element element4;
        Waypoint waypoint = null;
        Double d = null;
        Double d2 = null;
        Element element5 = this.getSubElement(element, "Position");
        if (element5 != null) {
            element4 = this.getSubElement(element5, "LatitudeDegrees");
            if (element4 != null) {
                d = Double.parseDouble(element4.getTextContent());
            }
            if ((element3 = this.getSubElement(element5, "LongitudeDegrees")) != null) {
                d2 = Double.parseDouble(element3.getTextContent());
            }
        }
        if (d == null || d2 == null) {
            return null;
        }
        waypoint = new Waypoint(d, d2);
        element4 = this.getSubElement(element, "AltitudeMeters");
        if (element4 != null) {
            double d3 = Double.parseDouble(element4.getTextContent());
            waypoint.setEle(d3);
        }
        if ((element3 = this.getSubElement(element, "Time")) != null) {
            object = DatatypeConverter.parseDateTime((String)element3.getTextContent());
            waypoint.setTime(((Calendar)object).getTime());
        }
        if ((object = this.getSubElement(element, "HeartRateBpm")) != null && (element2 = this.getSubElement((Element)object, "Value")) != null) {
            waypoint.getExtension().add(object.getNodeName(), element2.getTextContent());
        }
        return waypoint;
    }

    private void parseTrack(Track track, Element element) {
        WaypointGroup waypointGroup = track.addTrackseg();
        List<Element> list = this.getSubElementsByTagName(element, "Track");
        for (Element element2 : list) {
            List<Element> list2 = this.getSubElementsByTagName(element2, "Trackpoint");
            for (Element element3 : list2) {
                Waypoint waypoint = this.parseTrackPoint(element3);
                if (waypoint == null) continue;
                waypointGroup.addWaypoint(waypoint);
            }
        }
    }

    private void parseActivity(Element element, GPXFile gPXFile) {
        Object object;
        Element element2 = this.getSubElement(element, "Creator");
        if (element2 != null && (object = this.getSubElement(element2, "Name")) != null) {
            gPXFile.setCreator(object.getTextContent());
        }
        object = this.getSubElementsByTagName(element, "Lap");
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Element element3 = (Element)iterator.next();
            Track track = new Track(gPXFile.getColor(this.currentLoadColor++));
            track.setName(element3.getAttribute("StartTime"));
            this.parseTrack(track, element3);
            if (track.getTracksegs().size() <= 0) continue;
            gPXFile.addTrack(track);
        }
    }

    @Override
    public GPXFile load(InputStream inputStream, String string) throws Exception {
        this.gpx = new GPXFile();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(inputStream);
        document.normalize();
        Element element = document.getDocumentElement();
        List<Element> list = this.getSubElementsByTagName(element, "Activities");
        if (list.size() != 1) {
            throw new UnsupportedOperationException();
        }
        List<Element> list2 = this.getSubElements(list.get(0));
        for (Element element2 : list2) {
            String string2 = element2.getTagName();
            if (string2.equals("Activity")) {
                this.parseActivity(element2, this.gpx);
            }
            if (!string2.equals("MultiSportSession")) continue;
            List<Element> list3 = this.getSubElementsByTagName(element2, "FirstSport");
            if (list3.size() != 1) {
                throw new UnsupportedOperationException();
            }
            List<Element> list4 = this.getSubElementsByTagName(list3.get(0), "Activity");
            if (list4.size() != 1) {
                throw new UnsupportedOperationException();
            }
            this.parseActivity(list4.get(0), this.gpx);
            List<Element> list5 = this.getSubElementsByTagName(element2, "NextSport");
            for (Element element3 : list5) {
                List<Element> list6 = this.getSubElementsByTagName(element3, "Activitiy");
                if (list6.size() != 1) {
                    throw new UnsupportedOperationException();
                }
                this.parseActivity(list6.get(0), this.gpx);
            }
        }
        return this.gpx;
    }

    @Override
    public void loadCumulative(InputStream inputStream) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void save(GPXFile gPXFile, File file) throws FileNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void save(GPXFile gPXFile, OutputStream outputStream) {
        throw new UnsupportedOperationException();
    }
}

