/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.gpsloader;

import com.topografix.gpx._1._1.LinkType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.Calendar;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.gpsmaster.gpsloader.XmlLoader;
import org.gpsmaster.gpxpanel.GPXExtension;
import org.gpsmaster.gpxpanel.GPXFile;
import org.gpsmaster.gpxpanel.GpxMetadata;
import org.gpsmaster.gpxpanel.Route;
import org.gpsmaster.gpxpanel.Track;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.gpxpanel.WaypointGroup;
import org.gpsmaster.marker.Marker;
import org.gpsmaster.marker.NullMarker;
import org.gpsmaster.marker.PhotoMarker;
import org.gpsmaster.marker.WaypointMarker;
import org.gpsmaster.marker.WikiMarker;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GpxLoader
extends XmlLoader {
    public GpxLoader() {
        this.isAdding = false;
        this.isDefault = true;
        this.extensions.add("gpx");
        this.xsdResource = "/org/gpsmaster/schema/gpx-1.1.xsd";
    }

    private LinkType parseLink(Element element) {
        LinkType linkType = new LinkType();
        linkType.setHref(element.getAttribute("href"));
        linkType.setText(this.getSubValue(element, "text"));
        linkType.setType(this.getSubValue(element, "type"));
        return linkType;
    }

    private void parseMetadata(GpxMetadata gpxMetadata, Element element) {
        for (Element element2 : this.getSubElements(element)) {
            String string = element2.getNodeName();
            if (string.equals("name")) {
                gpxMetadata.setName(element2.getTextContent());
            }
            if (string.equals("desc")) {
                gpxMetadata.setDesc(element2.getTextContent());
            }
            if (string.equals("keywords")) {
                gpxMetadata.setKeywords(element2.getTextContent());
            }
            if (string.equals("time")) {
                Calendar calendar = DatatypeConverter.parseDateTime((String)element2.getTextContent());
                gpxMetadata.setTime(calendar.getTime());
            }
            if (string.equals("link")) {
                gpxMetadata.getLink().add(this.parseLink(element2));
            }
            if (!string.equals("extensions")) continue;
            this.parseExtension(gpxMetadata.getExtension(), element2);
        }
    }

    private void parseExtension(GPXExtension gPXExtension, Element element) {
        for (Element element2 : this.getSubElements(element)) {
            String string;
            GPXExtension gPXExtension2 = new GPXExtension();
            String string2 = element2.getNodeName();
            gPXExtension2.setKey(string2);
            if (element2.getFirstChild() != null && (string = element2.getFirstChild().getNodeValue()) != null) {
                gPXExtension2.setValue(string.replace("\n", "").trim());
            }
            gPXExtension.add(gPXExtension2);
            this.parseExtension(gPXExtension2, element2);
        }
    }

    private Waypoint parseTrackPoint(Element element) {
        Waypoint waypoint = null;
        double d = 0.0;
        double d2 = 0.0;
        try {
            d = Double.parseDouble(element.getAttribute("lat"));
            d2 = Double.parseDouble(element.getAttribute("lon"));
            waypoint = new Waypoint(d, d2);
            for (Element element2 : this.getSubElements(element)) {
                String string = element2.getTextContent().replace("\n", "");
                String string2 = element2.getNodeName();
                if (string2.equals("ele")) {
                    if (string.isEmpty()) continue;
                    waypoint.setEle(Double.parseDouble(string));
                    continue;
                }
                if (string2.equals("time")) {
                    Calendar calendar = DatatypeConverter.parseDateTime((String)string);
                    waypoint.setTime(calendar.getTime());
                    continue;
                }
                if (string2.equals("name")) {
                    waypoint.setName(string);
                    continue;
                }
                if (string2.equals("cmt")) {
                    waypoint.setCmt(string);
                    continue;
                }
                if (string2.equals("desc")) {
                    waypoint.setDesc(string);
                    continue;
                }
                if (string2.equals("src")) {
                    waypoint.setSrc(string);
                    continue;
                }
                if (string2.equals("sym")) {
                    waypoint.setSym(string);
                    continue;
                }
                if (string2.equals("fix")) {
                    waypoint.setFix(string);
                    continue;
                }
                if (string2.equals("type")) {
                    waypoint.setType(string);
                    continue;
                }
                if (string2.equals("link")) {
                    waypoint.getLink().add(this.parseLink(element2));
                    continue;
                }
                if (string2.equals("sat")) {
                    waypoint.setSat(Integer.parseInt(string));
                    continue;
                }
                if (string2.equals("hdop")) {
                    waypoint.setHdop(Double.parseDouble(string));
                    continue;
                }
                if (string2.equals("vdop")) {
                    waypoint.setVdop(Double.parseDouble(string));
                    continue;
                }
                if (string2.equals("pdop")) {
                    waypoint.setPdop(Double.parseDouble(string));
                    continue;
                }
                if (string2.equals("magvar")) {
                    waypoint.setMagvar(Double.parseDouble(string));
                    continue;
                }
                if (string2.equals("geoidheight")) {
                    waypoint.setGeoidheight(Double.parseDouble(string));
                    continue;
                }
                if (string2.equals("ageofdgpsdata")) {
                    waypoint.setAgeofdgpsdata(Double.parseDouble(string));
                    continue;
                }
                if (string2.equals("dgpsid")) {
                    waypoint.setDgpsid(Integer.parseInt(string));
                    continue;
                }
                if (string2.equals("extensions")) {
                    this.parseExtension(waypoint.getExtension(), element2);
                    continue;
                }
                waypoint.getExtension().add(new GPXExtension(string2, string));
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("caught numberFormat Exception");
        }
        return waypoint;
    }

    private void parseRoute(Route route, Element element) {
        for (Element element2 : this.getSubElements(element)) {
            Waypoint waypoint;
            String string = element2.getTextContent();
            String string2 = element2.getNodeName();
            if (string2.equals("number")) {
                route.setNumber(Integer.parseInt(string));
                continue;
            }
            if (string2.equals("name")) {
                route.setName(string);
                continue;
            }
            if (string2.equals("desc")) {
                route.setDesc(string);
                continue;
            }
            if (string2.equals("type")) {
                route.setType(string);
                continue;
            }
            if (string2.equals("extensions")) {
                this.parseExtension(route.getExtension(), element2);
                continue;
            }
            if (!string2.equals("rtept") || (waypoint = this.parseTrackPoint(element2)) == null) continue;
            route.getPath().addWaypoint(waypoint);
        }
    }

    private void parseSegment(WaypointGroup waypointGroup, Element element) {
        for (Element element2 : this.getSubElements(element)) {
            String string = element2.getNodeName();
            if (string.equals("trkpt")) {
                Waypoint waypoint = this.parseTrackPoint(element2);
                if (waypoint == null) continue;
                waypointGroup.addWaypoint(waypoint);
                continue;
            }
            if (!string.equals("extensions")) continue;
            this.parseExtension(waypointGroup.getExtension(), element2);
        }
    }

    private void parseTrack(Track track, Element element) {
        for (Element element2 : this.getSubElements(element)) {
            Object object;
            String string = element2.getTextContent().replace("\n", "");
            String string2 = element2.getNodeName();
            if (string2.equals("number")) {
                track.setNumber(Integer.parseInt(string));
                continue;
            }
            if (string2.equals("name")) {
                track.setName(string);
                continue;
            }
            if (string2.equals("desc")) {
                track.setDesc(string);
                continue;
            }
            if (string2.equals("type")) {
                track.setType(string);
                continue;
            }
            if (string2.equals("src")) {
                track.setSrc(string);
                continue;
            }
            if (string2.equals("link")) {
                object = this.parseLink(element2);
                track.getLink().add((LinkType)object);
                continue;
            }
            if (string2.equals("extensions")) {
                this.parseExtension(track.getExtension(), element2);
                continue;
            }
            if (!string2.equals("trkseg")) continue;
            object = track.addTrackseg();
            this.parseSegment((WaypointGroup)object, element2);
        }
    }

    private Marker waypointToMarker(Waypoint waypoint) {
        String string;
        Marker marker = null;
        if (waypoint.getExtension().containsKey("gpsm:marker")) {
            string = waypoint.getExtension().getSubValue("gpsm:marker");
            try {
                Class<?> clazz = Class.forName(string);
                Constructor<?> constructor = clazz.getConstructor(Waypoint.class);
                marker = (Marker)constructor.newInstance(waypoint);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (waypoint.getExtension().containsKey("gpsm:type")) {
            string = waypoint.getExtension().getSubValue("gpsm:type");
            if (string.equals("PhotoMarker")) {
                marker = new PhotoMarker(waypoint);
            } else if (string.equals("WikiMarker")) {
                marker = new WikiMarker(waypoint);
            } else if (string.equals("NullMarker")) {
                marker = new NullMarker(waypoint);
            }
        }
        if (marker == null) {
            marker = new WaypointMarker(waypoint);
        }
        return marker;
    }

    @Override
    public GPXFile load(InputStream inputStream, String string) throws Exception {
        Object object;
        Element element;
        Element element2;
        this.gpx = new GPXFile();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(inputStream);
        document.normalize();
        Element element3 = document.getDocumentElement();
        String string2 = element3.getAttribute("creator");
        if (!string2.isEmpty()) {
            this.gpx.setCreator(string2);
        }
        if ((element2 = this.getSubElement(element3, "metadata")) != null) {
            this.parseMetadata(this.gpx.getMetadata(), element2);
        }
        if ((element = this.getSubElement(element3, "extensions")) != null) {
            this.parseExtension(this.gpx.getExtension(), element);
        }
        for (Element element4 : this.getSubElementsByTagName(element3, "trk")) {
            object = new Track(this.gpx.getColor());
            this.parseTrack((Track)object, element4);
            if (((Track)object).getTracksegs().size() <= 0) continue;
            this.gpx.addTrack((Track)object);
        }
        for (Element element4 : this.getSubElementsByTagName(element3, "rte")) {
            object = new Route(this.gpx.getColor());
            this.parseRoute((Route)object, element4);
            if (((Route)object).getPath().getWaypoints().size() <= 0) continue;
            this.gpx.addRoute((Route)object);
        }
        for (Element element4 : this.getSubElementsByTagName(element3, "wpt")) {
            object = this.parseTrackPoint(element4);
            if (element4 == null) continue;
            Marker marker = this.waypointToMarker((Waypoint)object);
            this.gpx.getWaypointGroup().addWaypoint(marker);
        }
        return this.gpx;
    }

    @Override
    public void loadCumulative(InputStream inputStream) throws Exception {
        throw new UnsupportedOperationException();
    }

    private void writeLink(LinkType linkType) throws XMLStreamException {
        this.writeStartElement("link");
        this.writer.writeAttribute("href", linkType.getHref());
        if (linkType.getText() != null) {
            this.writeSimpleElement("text", linkType.getText());
        }
        if (linkType.getType() != null) {
            this.writeSimpleElement("type", linkType.getType());
        }
        this.writeEndElement();
    }

    private void writeWaypoint(Waypoint waypoint, String string) throws XMLStreamException {
        this.writeStartElement(string);
        this.writeAttribute("lat", waypoint.getLat());
        this.writeAttribute("lon", waypoint.getLon());
        if (waypoint.getEle() > 0.0) {
            this.writeSimpleElement("ele", waypoint.getEle());
        }
        this.writeSimpleElement("time", waypoint.getTime());
        if (waypoint.getMagvar() > 0.0) {
            this.writeSimpleElement("magvar", waypoint.getMagvar());
        }
        if (waypoint.getGeoidheight() > 0.0) {
            this.writeSimpleElement("geoidheight", waypoint.getGeoidheight());
        }
        this.writeSimpleElement("name", waypoint.getName());
        this.writeSimpleElement("cmt", waypoint.getCmt());
        this.writeSimpleElement("desc", waypoint.getDesc());
        this.writeSimpleElement("src", waypoint.getSrc());
        for (LinkType linkType : waypoint.getLink()) {
            this.writeLink(linkType);
        }
        this.writeSimpleElement("sym", waypoint.getSym());
        this.writeSimpleElement("type", waypoint.getType());
        this.writeSimpleElement("fix", waypoint.getFix());
        if (waypoint.getSat() > 0) {
            this.writeSimpleElement("sat", waypoint.getSat());
        }
        if (waypoint.getHdop() > 0.0) {
            this.writeSimpleElement("hdop", waypoint.getHdop());
        }
        if (waypoint.getVdop() > 0.0) {
            this.writeSimpleElement("vdop", waypoint.getVdop());
        }
        if (waypoint.getPdop() > 0.0) {
            this.writeSimpleElement("pdop", waypoint.getPdop());
        }
        if (waypoint.getAgeofdgpsdata() > 0.0) {
            this.writeSimpleElement("ageofdgpsdata", waypoint.getAgeofdgpsdata());
        }
        if (waypoint.getDgpsid() > 0) {
            this.writeSimpleElement("dgpsid", waypoint.getDgpsid());
        }
        this.writeExtension(waypoint.getExtension());
        this.writeEndElement();
    }

    private void writeTrack(Track track) throws XMLStreamException {
        this.writeStartElement("trk");
        if (track.getNumber() > 0) {
            this.writeSimpleElement("number", track.getNumber());
        }
        this.writeSimpleElement("name", track.getName());
        this.writeSimpleElement("desc", track.getDesc());
        this.writeSimpleElement("type", track.getType());
        this.writeLinks(track.getLink());
        this.writeExtension(track.getExtension());
        for (WaypointGroup waypointGroup : track.getTracksegs()) {
            this.writeStartElement("trkseg");
            this.writeWayPointGroup(waypointGroup.getWaypoints(), "trkpt");
            this.writeExtension(waypointGroup.getExtension());
            this.writeEndElement();
        }
        this.writeEndElement();
    }

    private void writeRoute(Route route) throws XMLStreamException {
        this.writeStartElement("rte");
        if (route.getNumber() > 0) {
            this.writeSimpleElement("number", route.getNumber());
        }
        this.writeSimpleElement("name", route.getName());
        this.writeSimpleElement("desc", route.getDesc());
        this.writeSimpleElement("type", route.getType());
        this.writeExtension(route.getExtension());
        this.writeWayPointGroup(route.getPath().getWaypoints(), "rtept");
        this.writeEndElement();
    }

    private void writeWayPointGroup(List<Waypoint> list, String string) throws XMLStreamException {
        for (Waypoint waypoint : list) {
            this.writeWaypoint(waypoint, string);
        }
    }

    private void writeExtension(GPXExtension gPXExtension) throws XMLStreamException {
        if (gPXExtension.getExtensions().size() > 0) {
            this.writeSubtree(gPXExtension);
        }
    }

    private void writeLinks(List<LinkType> list) throws XMLStreamException {
        for (LinkType linkType : list) {
            this.writeLink(linkType);
        }
    }

    private void writeMetadata(GpxMetadata gpxMetadata) throws XMLStreamException {
        this.writeStartElement("metadata");
        this.writeSimpleElement("name", gpxMetadata.getName());
        this.writeSimpleElement("desc", gpxMetadata.getDesc());
        this.writeSimpleElement("keywords", gpxMetadata.getKeywords());
        if (gpxMetadata.getTime() != null) {
            this.writeSimpleElement("time", gpxMetadata.getTime());
        }
        this.writeLinks(gpxMetadata.getLink());
        this.writer.writeEmptyElement("bounds");
        this.writeAttribute("minlat", gpxMetadata.getBounds().getMinlat().doubleValue());
        this.writeAttribute("minlon", gpxMetadata.getBounds().getMinlon().doubleValue());
        this.writeAttribute("maxlat", gpxMetadata.getBounds().getMaxlat().doubleValue());
        this.writeAttribute("maxlon", gpxMetadata.getBounds().getMaxlon().doubleValue());
        this.writeExtension(gpxMetadata.getExtension());
        this.writeEndElement();
    }

    public void save(GPXFile gPXFile, File file) throws FileNotFoundException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.save(gPXFile, fileOutputStream);
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void save(GPXFile gPXFile, OutputStream outputStream) {
        XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
        try {
            this.writer = xMLOutputFactory.createXMLStreamWriter(outputStream, "UTF-8");
            this.writer.writeStartDocument("UTF-8", "1.0");
            this.writer.writeCharacters("\n\n");
            this.writer.writeStartElement("gpx");
            this.writer.writeAttribute("version", "1.1");
            if (gPXFile.getCreator().isEmpty()) {
                this.writer.writeAttribute("creator", "GpsMaster 0.63.31");
            } else {
                this.writer.writeAttribute("creator", gPXFile.getCreator());
            }
            this.writer.writeAttribute("xmlns", "http://www.topografix.com/GPX/1/1");
            this.writer.writeAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.writer.writeAttribute("xsi:schemaLocation", "http://www.topografix.com/GPX/1/1 http://www.topografix.com/GPX/1/1/gpx.xsd");
            for (String object : gPXFile.getExtensionPrefixes()) {
                this.writer.writeAttribute("xmlns:" + object, "http://www.gpsmaster.org/schema/" + object + "/v1");
            }
            this.writeMetadata(gPXFile.getMetadata());
            this.writeWayPointGroup(gPXFile.getWaypointGroup().getWaypoints(), "wpt");
            for (Track track : gPXFile.getTracks()) {
                this.writeTrack(track);
            }
            for (Route route : gPXFile.getRoutes()) {
                this.writeRoute(route);
            }
            this.writeSubtree(gPXFile.getExtension());
            this.writer.writeEndElement();
            this.writer.writeEndDocument();
        }
        catch (XMLStreamException xMLStreamException) {
            xMLStreamException.printStackTrace();
        }
    }
}

