/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.filehub;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.FileAlreadyExistsException;
import org.gpsmaster.filehub.DataType;
import org.gpsmaster.filehub.IItemTarget;
import org.gpsmaster.filehub.TransferableItem;
import org.gpsmaster.gpxpanel.GPXFile;

public class FileTarget
implements IItemTarget {
    private String directory = null;
    protected TransferableItem item = null;
    protected FileOutputStream fos = null;
    protected boolean enabled = true;
    private boolean overwrite = false;

    @Override
    public String getName() {
        return "Filesystem";
    }

    @Override
    public String getDescription() {
        return "Save to Filesystem";
    }

    @Override
    public DataType getDataType() {
        return DataType.STREAM;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String string) {
        this.directory = string;
    }

    protected boolean getOverwrite() {
        return this.overwrite;
    }

    protected void setOverwrite(boolean bl) {
        this.overwrite = bl;
    }

    @Override
    public boolean doShowProgressText() {
        return false;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Override
    public String getRequiredFormat() {
        return null;
    }

    @Override
    public void addGpxFile(GPXFile gPXFile, TransferableItem transferableItem) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void open(TransferableItem transferableItem) throws Exception {
        this.item = transferableItem;
        String string = "";
        if (this.directory != null) {
            string = this.directory;
        }
        String string2 = this.item.getName();
        String string3 = this.item.getSourceFormat();
        if (string3 != null && !string2.endsWith(string3)) {
            string2 = string2 + "." + string3;
        }
        if (new File(string2).exists() && !this.overwrite) {
            throw new FileAlreadyExistsException(string2);
        }
        this.fos = new FileOutputStream(string + File.separator + string2);
    }

    @Override
    public OutputStream getOutputStream() {
        return this.fos;
    }

    @Override
    public void close() throws Exception {
        this.item = null;
        if (this.fos != null) {
            this.fos.flush();
            this.fos.close();
            this.fos = null;
        }
    }
}

