/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.dialogs;

import eu.fuegenstein.gis.GeoBounds;
import eu.fuegenstein.messagecenter.MessageCenter;
import eu.fuegenstein.swing.ExtendedTable;
import eu.fuegenstein.unit.UnitConverter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gpsmaster.dialogs.BrowserLauncher;
import org.gpsmaster.dialogs.GenericDialog;
import org.gpsmaster.dialogs.ItemTargetSelectionPanel;
import org.gpsmaster.dialogs.TransferableItemLogPanel;
import org.gpsmaster.dialogs.TransferableItemTableModel;
import org.gpsmaster.filehub.FileHub;
import org.gpsmaster.filehub.IItemSource;
import org.gpsmaster.online.OnlineTrack;

public abstract class GenericDownloadDialog
extends GenericDialog
implements IItemSource {
    private static final long serialVersionUID = 2219627677527086720L;
    protected TransferableItemTableModel trackListModel = null;
    protected ExtendedTable trackTable = null;
    protected boolean cancelled = false;
    protected String errorMessage = null;
    private JTextArea descriptionBox = null;
    protected JButton refreshButton = null;
    protected JButton loadButton = null;
    protected JButton cancelButton = null;
    protected JButton showButton = null;
    protected JPanel mainPanel = new JPanel();
    protected JPanel northPanel = new JPanel();
    protected JPanel centerPanel = new JPanel();
    protected JPanel boundsPanel = new JPanel();
    protected JPanel southPanel = new JPanel();
    protected JPanel descPanel = new JPanel();
    protected ItemTargetSelectionPanel targetPanel = null;
    protected JPanel buttonPanel = new JPanel();
    protected TransferableItemLogPanel statusPanel = new TransferableItemLogPanel();
    protected PropertyChangeListener changeListener = null;
    protected PropertyChangeListener fileHubListener = null;
    protected GeoBounds bounds = null;
    protected JLabel boundsLabel = new JLabel();
    protected FileHub fileHub = null;

    public GenericDownloadDialog(JFrame jFrame, MessageCenter messageCenter, FileHub fileHub, UnitConverter unitConverter) {
        super(jFrame, messageCenter);
        this.fileHub = fileHub;
        this.uc = unitConverter;
        this.setupListeners();
        this.setupMainPanel();
        this.setupNorthPanel();
        this.setupTableModel();
        this.initializeTable();
        this.setupTable();
        this.setupCenterPanel();
        this.setupTargetPanel();
        this.setupSouthPanel();
        this.pack();
        this.setCenterLocation();
        this.trackListModel.clear();
        this.loadButton.setEnabled(false);
        this.showButton.setEnabled(false);
        this.cancelled = false;
        this.descriptionBox.setText("");
        this.errorMessage = null;
        this.setVisible(true);
    }

    public void setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeListener = propertyChangeListener;
    }

    public PropertyChangeListener getPropertyChangeListener() {
        return this.changeListener;
    }

    public GeoBounds getGeoBounds() {
        return this.bounds;
    }

    public void setGeoBounds(GeoBounds geoBounds) {
        this.bounds = geoBounds;
        this.boundsLabel.setText(geoBounds.toString());
    }

    @Override
    public abstract void begin();

    private void setupListeners() {
        this.fileHubListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("transferItemStateChanged")) {
                    GenericDownloadDialog.this.trackListModel.refreshTrack((OnlineTrack)propertyChangeEvent.getNewValue());
                } else if (string.equals("transferStarted")) {
                    GenericDownloadDialog.this.cancelButton.setEnabled(true);
                } else if (string.equals("transferFinished")) {
                    GenericDownloadDialog.this.cancelButton.setEnabled(false);
                }
            }
        };
        this.fileHub.addChangeListener(this.fileHubListener);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                GenericDownloadDialog.this.fileHub.removeChangeListener(GenericDownloadDialog.this.fileHubListener);
            }
        });
    }

    private void setupMainPanel() {
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        this.northPanel.setLayout(new BoxLayout(this.northPanel, 1));
        this.mainPanel.add((Component)this.northPanel, "North");
        this.mainPanel.add((Component)this.southPanel, "South");
        this.getContentPane().add(this.mainPanel);
    }

    private void setupNorthPanel() {
        this.boundsLabel.setText(" - - - -");
        this.boundsPanel.add(this.boundsLabel);
        this.boundsPanel.setVisible(true);
        this.northPanel.add(this.boundsPanel);
    }

    private void setupCenterPanel() {
        JScrollPane jScrollPane = new JScrollPane(this.trackTable);
        this.mainPanel.add((Component)jScrollPane, "Center");
    }

    protected void setupTargetPanel() {
        if (this.fileHub != null) {
            this.targetPanel = new ItemTargetSelectionPanel(this.fileHub.getItemTargets());
            this.targetPanel.setVisible(true);
        }
    }

    private void setupSouthPanel() {
        this.southPanel.setLayout(new BoxLayout(this.southPanel, 1));
        this.statusPanel.setVisible(false);
        this.statusPanel.setAutoHide(true);
        this.southPanel.add(this.statusPanel);
        this.descPanel.setLayout(new BorderLayout());
        this.descPanel.add((Component)new JLabel("Description:"), "North");
        this.descriptionBox = new JTextArea(5, 20);
        this.descriptionBox.setEditable(false);
        this.descriptionBox.setLineWrap(true);
        this.descriptionBox.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(this.descriptionBox);
        jScrollPane.setPreferredSize(new Dimension(400, 80));
        this.descPanel.add((Component)jScrollPane, "Center");
        this.descPanel.setVisible(false);
        this.southPanel.add(jScrollPane);
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.showButton = new JButton("Show Webpage");
        this.showButton.setEnabled(false);
        this.showButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenericDownloadDialog.this.showSelectedWebpage();
            }
        });
        this.buttonPanel.add(this.showButton);
        this.loadButton = new JButton("Load");
        this.loadButton.setEnabled(false);
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenericDownloadDialog.this.loadSelected();
            }
        });
        this.buttonPanel.add(this.loadButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenericDownloadDialog.this.cancelled = true;
                GenericDownloadDialog.this.fileHub.cancel();
            }
        });
        this.cancelButton.setEnabled(false);
        this.buttonPanel.add(this.cancelButton);
        JButton jButton = new JButton("Close");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenericDownloadDialog.this.dispose();
            }
        });
        this.buttonPanel.add(jButton);
        this.southPanel.add(this.buttonPanel);
        if (this.targetPanel != null) {
            this.southPanel.add(this.targetPanel);
        }
    }

    protected abstract void setupTableModel();

    protected void initializeTable() {
        this.trackTable = new ExtendedTable(this.trackListModel);
        this.trackTable.setAutoCreateRowSorter(true);
        this.trackTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    int n = GenericDownloadDialog.this.trackTable.getSelectedRowCount();
                    if (n > 0) {
                        OnlineTrack onlineTrack = (OnlineTrack)GenericDownloadDialog.this.trackListModel.getItem(GenericDownloadDialog.this.trackTable.getSelectedRow());
                        GenericDownloadDialog.this.statusPanel.setLog(onlineTrack.getLog());
                        GenericDownloadDialog.this.setDescription(onlineTrack.getDescription());
                        GenericDownloadDialog.this.descriptionBox.setCaretPosition(0);
                    } else {
                        GenericDownloadDialog.this.descriptionBox.setText("");
                    }
                    GenericDownloadDialog.this.loadButton.setEnabled(n > 0);
                    GenericDownloadDialog.this.showButton.setEnabled(n == 1);
                }
            }
        });
    }

    protected abstract void setupTable();

    protected abstract String getColumnKey(int var1);

    private void setDescription(String string) {
        String string2 = string;
        if (string == null || string.length() < 2) {
            string2 = "";
        }
        this.descriptionBox.setText(string2);
    }

    protected abstract void loadSelected();

    private void showSelectedWebpage() {
        int n = this.trackTable.convertRowIndexToModel(this.trackTable.getSelectedRow());
        if (n >= 0 && n < this.trackListModel.getRowCount()) {
            String string = ((OnlineTrack)this.trackListModel.getItem(n)).getWebUrl();
            BrowserLauncher.launchBrowser(string);
        }
    }
}

