/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.dialogs;

import eu.fuegenstein.messagecenter.MessageCenter;
import eu.fuegenstein.messagecenter.MessagePanel;
import eu.fuegenstein.unit.UnitConverter;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import org.gpsmaster.GpsMaster;

public abstract class GenericDialog
extends JFrame {
    private static final long serialVersionUID = 2979483355856594216L;
    protected MessageCenter msg = null;
    protected JFrame parentFrame = null;
    protected MessagePanel msgPanel = null;
    protected Container contentPane = null;
    protected UnitConverter uc = null;
    protected Color backgroundColor = Color.WHITE;

    public GenericDialog(JFrame jFrame) {
        this.parentFrame = jFrame;
        this.contentPane = this.getContentPane();
        this.setDefaultCloseOperation(2);
    }

    public GenericDialog(JFrame jFrame, MessageCenter messageCenter) {
        this(jFrame);
        this.msg = messageCenter;
    }

    public UnitConverter getUnitConverter() {
        return this.uc;
    }

    public void setUnitConverter(UnitConverter unitConverter) {
        this.uc = unitConverter;
    }

    protected void setCenterLocation() {
        this.setLocationRelativeTo(this.parentFrame);
        Point point = new Point();
        point.x = this.parentFrame.getLocation().x + this.parentFrame.getWidth() / 2 - this.getWidth() / 2;
        point.y = this.parentFrame.getLocation().y + this.parentFrame.getHeight() / 2 - this.getHeight() / 2;
        this.setLocation(point);
    }

    protected void xsetSizeAndCenter(int n, int n2) {
        this.setSize(n, n);
        this.setCenterLocation();
    }

    public abstract void begin();

    @Override
    public abstract String getTitle();

    protected void setIcon(String string, String string2) {
        this.setIconImage(new ImageIcon(GpsMaster.class.getResource(string + string2)).getImage());
    }

    protected void busyOn() {
        this.setCursor(new Cursor(3));
    }

    protected void busyOff() {
        this.setCursor(new Cursor(0));
    }
}

