/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.device;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.NoSuchElementException;
import org.gpsmaster.device.MTPLoader;
import org.gpsmaster.gpxpanel.GPXFile;
import org.gpsmaster.gpxpanel.Track;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.gpxpanel.WaypointGroup;
import org.gpsmaster.online.OnlineTrack;

public class MoveBikeCompMPT
extends MTPLoader {
    Connection sqlConn = null;

    public MoveBikeCompMPT() throws ClassNotFoundException {
        this.key = "MBCMPT";
        this.name = "Move!BikeComputer via MPT";
        this.description = "Load tracks recorded with Move!BikeComputer via MTP from Android device";
        this.canDelete = false;
        Class.forName("org.sqlite.JDBC");
    }

    @Override
    public void connect() throws SQLException {
        if (!this.isConnected) {
            if (!this.connectionParams.containsKey("DBFILE")) {
                throw new NoSuchElementException("Connection Parameter DBFILE");
            }
            this.sqlConn = DriverManager.getConnection("jdbc:sqlite:" + (String)this.connectionParams.get("DBFILE"));
            this.isConnected = true;
        }
    }

    @Override
    public List<OnlineTrack> getTracklist() throws Exception {
        this.checkConnection();
        String string = "SELECT _id, start_time, track_name from tracks ORDER BY start_time DESC";
        ArrayList<OnlineTrack> arrayList = new ArrayList<OnlineTrack>();
        try {
            Statement statement = this.sqlConn.createStatement();
            ResultSet resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                Integer n = resultSet.getInt("_ID");
                OnlineTrack onlineTrack = new OnlineTrack();
                onlineTrack.setId(n.intValue());
                onlineTrack.setDate(new Date(resultSet.getLong("start_time")));
                onlineTrack.setName(resultSet.getString("track_name"));
                arrayList.add(onlineTrack);
            }
        }
        catch (SQLException sQLException) {
            throw new Exception(sQLException.getMessage());
        }
        return arrayList;
    }

    @Override
    public GPXFile load(OnlineTrack onlineTrack) throws Exception {
        this.checkConnection();
        GPXFile gPXFile = new GPXFile();
        gPXFile.getMetadata().setTime(onlineTrack.getDate());
        gPXFile.getMetadata().setName(String.format("%1$tY%1$tm%1$td_%1$tH%1$tm", onlineTrack.getDate()));
        gPXFile.getMetadata().setDesc(String.format("Move!BikeComputer Track #%d", onlineTrack.getId()));
        Track track = new Track(gPXFile.getColor());
        track.setNumber(1);
        track.setName(onlineTrack.getName());
        gPXFile.addTrack(track);
        WaypointGroup waypointGroup = new WaypointGroup(gPXFile.getColor(), WaypointGroup.WptGrpType.TRACKSEG);
        track.addTrackseg(waypointGroup);
        String string = "SELECT latitude, longitude, altitude, time, speed, bearing FROM track_points WHERE track_id = ? ORDER BY time";
        try {
            PreparedStatement preparedStatement = this.sqlConn.prepareStatement(string);
            preparedStatement.setLong(1, onlineTrack.getId());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Waypoint waypoint = new Waypoint(resultSet.getDouble("latitude"), resultSet.getDouble("longitude"));
                waypoint.setEle(resultSet.getDouble("altitude"));
                long l = new Double(resultSet.getDouble("time")).longValue();
                waypoint.setTime(new Date(l));
                waypoint.setEle(resultSet.getDouble("altitude"));
                if (this.getExtended) {
                    waypoint.getExtension().add("speed", String.format("%.2f", resultSet.getDouble("speed")));
                    waypoint.getExtension().add("heading", String.format("%.2f", resultSet.getDouble("bearing")));
                }
                waypointGroup.addWaypoint(waypoint);
            }
        }
        catch (SQLException sQLException) {
            throw new Exception(sQLException.getMessage());
        }
        return gPXFile;
    }

    @Override
    public void disconnect() throws SQLException {
        if (this.sqlConn != null) {
            this.sqlConn.close();
        }
        this.isConnected = false;
    }
}

