/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.db;

import com.topografix.gpx._1._1.BoundsType;
import java.awt.Color;
import java.util.Date;
import java.util.Hashtable;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;
import org.gpsmaster.filehub.TransferableItem;
import org.gpsmaster.gpxpanel.GPXFile;

public class GpsRecord
extends TransferableItem {
    private String name;
    private Date startTime;
    private Date endTime;
    private long distance = 0L;
    private long duration = 0L;
    private Hashtable<String, String> tags = null;
    private BoundsType bounds = null;
    private String activity = "";
    private int rgbColor = 0xFFFFFF;
    private String sourceUrn;
    private long id = -1L;
    private String loaderClass;
    private String progVersion;
    private long userId = 0L;
    private boolean compressed = false;
    private Date entryDate;
    private String checksum = "";

    public GpsRecord() {
    }

    public GpsRecord(GPXFile gPXFile) {
        this.setFields(gPXFile);
    }

    public void setFields(GPXFile gPXFile) {
        this.id = gPXFile.getDbId();
        this.setName(gPXFile.getName());
        this.setColor(gPXFile.getColor());
        this.startTime = gPXFile.getStartTime();
        this.endTime = gPXFile.getEndTime();
        this.distance = (long)gPXFile.getLengthMeters();
        this.duration = gPXFile.getDuration();
        this.bounds = gPXFile.getMetadata().getBounds();
        if (gPXFile.getExtension().containsKey("gpsm:activity")) {
            this.setActivity(gPXFile.getExtension().getSubValue("gpsm:activity"));
        }
        this.loaderClass = "";
        this.progVersion = "GpsMaster 0.63.31";
        this.sourceUrn = "";
        this.userId = 0L;
        this.compressed = false;
        this.entryDate = new Date();
        this.checksum = "";
    }

    public long getId() {
        return this.id;
    }

    public void setId(long l) {
        this.id = l;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date date) {
        this.startTime = date;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date date) {
        this.endTime = date;
    }

    public long getDistance() {
        return this.distance;
    }

    public void setDistance(long l) {
        this.distance = l;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long l) {
        this.duration = l;
    }

    public BoundsType getBounds() {
        if (this.bounds == null) {
            this.bounds = new BoundsType();
        }
        return this.bounds;
    }

    public void setBounds(BoundsType boundsType) {
        this.bounds = boundsType;
    }

    public String getActivity() {
        return this.activity;
    }

    public void setActivity(String string) {
        this.activity = string;
    }

    public Color getColor() {
        return new Color(this.rgbColor);
    }

    public void setColor(Color color) {
        this.rgbColor = color.getRGB();
    }

    public int getRgbColor() {
        return this.rgbColor;
    }

    public void setRgbColor(int n) {
        this.rgbColor = n;
    }

    public String getSourceUrn() {
        return this.sourceUrn;
    }

    public void setSourceUrn(String string) {
        this.sourceUrn = string;
    }

    @Override
    public String getLoaderClassName() {
        return this.loaderClass;
    }

    @Override
    public void setLoaderClassName(String string) {
        this.loaderClass = string;
    }

    public String getProgVersion() {
        return this.progVersion;
    }

    public void setProgVersion(String string) {
        this.progVersion = string;
    }

    public long getUserId() {
        return this.userId;
    }

    public void setUserId(long l) {
        this.userId = l;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void setCompressed(boolean bl) {
        this.compressed = bl;
    }

    public Date getEntryDate() {
        return this.entryDate;
    }

    public void setEntryDate(Date date) {
        this.entryDate = date;
    }

    private Hashtable<String, String> getTags() {
        return this.tags;
    }

    private void setTags(Hashtable<String, String> hashtable) {
        this.tags = hashtable;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String string) {
        this.checksum = string;
    }

    public void setChecksum(byte[] byArray) {
        String string;
        this.checksum = string = new HexBinaryAdapter().marshal(byArray);
    }
}

