/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.cleaning;

import eu.fuegenstein.parameter.DoubleParameter;
import java.util.List;
import org.gpsmaster.cleaning.CleaningAlgorithm;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.gpxpanel.WaypointGroup;

public class Singleton
extends CleaningAlgorithm {
    private DoubleParameter parameter = new DoubleParameter(2.0);

    public Singleton() {
        this.parameter.setDescription("factor");
        this.parameter.setName("avgFactor");
        this.parameter.setFormat("%.1f");
        this.params.add(this.parameter);
    }

    @Override
    public String getName() {
        return "Singleton";
    }

    @Override
    public String getDescription() {
        String string = "Remove points away from their neighbours by (factor) times more than the average";
        return string;
    }

    @Override
    protected void applyAlgorithm(WaypointGroup waypointGroup, List<Waypoint> list) {
        List<Waypoint> list2 = waypointGroup.getWaypoints();
        double d = waypointGroup.getLengthMeters() / (double)(waypointGroup.getWaypoints().size() - 1);
        double d2 = d * this.parameter.getValue();
        if (list2.size() < 3) {
            throw new IllegalArgumentException("Not enough trackpoints");
        }
        for (int i = 1; i < list2.size() - 1; ++i) {
            Waypoint waypoint = list2.get(i - 1);
            Waypoint waypoint2 = list2.get(i);
            Waypoint waypoint3 = list2.get(i + 1);
            double d3 = waypoint2.getDistance(waypoint);
            double d4 = waypoint2.getDistance(waypoint3);
            if (!(d3 > d2) || !(d4 > d2)) continue;
            list.add(waypoint2);
        }
    }
}

