/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.chart;

import org.gpsmaster.chart.ChartYAxis;
import org.gpsmaster.gpxpanel.Waypoint;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.renderer.xy.XYAreaRenderer;

public class GpsDataAxis
extends ChartYAxis {
    public static final byte HDOP = 0;
    public static final byte PDOP = 1;
    public static final byte VDOP = 2;
    public static final byte SAT = 3;
    public static final byte MAGVAR = 4;
    public static final byte FIRST = 0;
    public static final byte LAST = 4;
    private byte field = 0;

    public GpsDataAxis(byte by) {
        super(null);
        this.field = by;
        switch (by) {
            case 0: {
                this.title = "HDOP";
                break;
            }
            case 1: {
                this.title = "PDOP";
                break;
            }
            case 2: {
                this.title = "VDOP";
                break;
            }
            case 3: {
                this.title = "SAT";
                break;
            }
            case 4: {
                this.title = "MAGVAR";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.iconFile = "axis_gps.png";
        this.valueAxis = new NumberAxis();
        this.valueAxis.setLabel(this.title);
        this.renderer = new XYAreaRenderer(4);
        super.setDefaults();
    }

    public byte getField() {
        return this.field;
    }

    @Override
    public double getValue(Waypoint waypoint) {
        switch (this.field) {
            case 0: {
                return waypoint.getHdop();
            }
            case 1: {
                return waypoint.getPdop();
            }
            case 2: {
                return waypoint.getVdop();
            }
            case 3: {
                return waypoint.getSat();
            }
            case 4: {
                return waypoint.getMagvar();
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void reset() {
    }
}

