/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.chart;

import javax.swing.ImageIcon;
import org.gpsmaster.GpsMaster;
import org.gpsmaster.chart.ChartYAxis;
import org.gpsmaster.gpxpanel.Waypoint;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.renderer.xy.XYAreaRenderer;

public class ExtensionAxis
extends ChartYAxis {
    private String key = null;

    public ExtensionAxis(String string) {
        super(null);
        this.key = string;
        this.title = string;
        this.iconFile = "axis_extension.png";
        this.valueAxis = new NumberAxis();
        this.valueAxis.setLabel(this.key);
        this.renderer = new XYAreaRenderer(4);
        super.setDefaults();
        try {
            String string2 = "ext_" + string.replaceAll(":", "_") + ".png";
            this.icon = new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/chart/" + string2));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public String getExtensionKey() {
        return this.key;
    }

    @Override
    public double getValue(Waypoint waypoint) {
        double d = 0.0;
        if (waypoint != null && waypoint.getExtension().containsKey(this.key)) {
            try {
                d = Double.parseDouble(waypoint.getExtension().getSubValue(this.key));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return d;
    }

    @Override
    public void reset() {
    }
}

