/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.chart;

import eu.fuegenstein.unit.UnitConverter;
import org.gpsmaster.chart.ChartYAxis;
import org.gpsmaster.gpxpanel.Waypoint;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.renderer.xy.XYAreaRenderer;

public class ElevationAxis
extends ChartYAxis {
    public ElevationAxis(UnitConverter unitConverter) {
        super(unitConverter);
        this.title = "Elevation";
        this.iconFile = "axis_elevation.png";
        this.valueAxis = new NumberAxis();
        this.valueAxis.setLabel(unitConverter.getTargetSet().getElevationUnit().getSymbol());
        this.renderer = new XYAreaRenderer(4);
        super.setDefaults();
    }

    @Override
    public double getValue(Waypoint waypoint) {
        if (waypoint == null) {
            return 0.0;
        }
        double d = waypoint.getEle();
        if (this.uc != null) {
            d = this.uc.ele(d);
        }
        this.setMinMax(d);
        return d;
    }

    @Override
    public void reset() {
        this.min = Double.MAX_VALUE;
        this.max = Double.MIN_VALUE;
    }
}

