/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.chart;

import eu.fuegenstein.unit.UnitConverter;
import org.gpsmaster.chart.ChartAxis;
import org.jfree.chart.axis.AxisLabelLocation;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.ui.RectangleInsets;

public abstract class ChartYAxis
extends ChartAxis {
    protected double min = Double.MAX_VALUE;
    protected double max = Double.MIN_VALUE;
    protected double padding = 0.0;
    protected AbstractRenderer renderer = null;

    public ChartYAxis(UnitConverter unitConverter) {
        super(unitConverter);
    }

    protected double getMin() {
        return this.min;
    }

    protected double getMax() {
        return this.max;
    }

    private void setPaddingRange() {
        if (this.padding > 0.0 && this.min < this.max) {
            double d = (this.max - this.min) * this.padding;
            this.valueAxis.setRange(this.min - d, this.max + d);
        }
    }

    protected void setMinMax(double d) {
        if (d < this.min) {
            this.min = d;
            this.setPaddingRange();
        } else if (d > this.max) {
            this.max = d;
            this.setPaddingRange();
        }
    }

    public void setPadding(double d) {
        this.padding = d;
    }

    public AbstractRenderer getPreferredRenderer() {
        return this.renderer;
    }

    @Override
    protected void setDefaults() {
        super.setDefaults();
        this.valueAxis.setLabelLocation(AxisLabelLocation.HIGH_END);
        this.valueAxis.setTickLabelInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
    }
}

