/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.chart;

import eu.fuegenstein.swing.JButtonlessComboBox;
import eu.fuegenstein.unit.UnitConverter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JSplitPane;
import org.gpsmaster.GpsMaster;
import org.gpsmaster.chart.ChartAxis;
import org.gpsmaster.chart.ChartDataset;
import org.gpsmaster.chart.ChartWindow;
import org.gpsmaster.chart.ChartXAxis;
import org.gpsmaster.chart.ChartYAxis;
import org.gpsmaster.chart.ComboAxisRenderer;
import org.gpsmaster.chart.DistanceAxis;
import org.gpsmaster.chart.DurationAxis;
import org.gpsmaster.chart.ElevationAxis;
import org.gpsmaster.chart.ExtensionAxis;
import org.gpsmaster.chart.FloatableChartPanel;
import org.gpsmaster.chart.GpsDataAxis;
import org.gpsmaster.chart.GpsMasterChartTheme;
import org.gpsmaster.chart.InteractiveChart;
import org.gpsmaster.chart.SpeedAxis;
import org.gpsmaster.chart.TimeAxis;
import org.gpsmaster.gpxpanel.GPXExtension;
import org.gpsmaster.gpxpanel.GPXObject;
import org.gpsmaster.gpxpanel.WaypointGroup;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;

public class ChartHandler {
    private UnitConverter uc = null;
    private JSplitPane parentPane = null;
    private double dividerLocation = 0.85f;
    private ChartXAxis xAxis = null;
    private ChartYAxis yAxis = null;
    private JButtonlessComboBox<ChartAxis> xCombo = null;
    private JButtonlessComboBox<ChartAxis> yCombo = null;
    private FloatableChartPanel chartPanel = null;
    private InteractiveChart chart = null;
    private ChartDataset dataset = new ChartDataset();
    private XYPlot plot = null;
    private List<String> extKeys = new ArrayList<String>();
    private List<Byte> gpsFields = new ArrayList<Byte>();
    private ChartWindow chartWindow = null;
    private PropertyChangeListener changeListener = null;
    private MouseAdapter tearListener = null;
    private final int SCANFIRST = 50;

    public ChartHandler(UnitConverter unitConverter) {
        this.uc = unitConverter;
        this.makeListeners();
        this.init();
        this.refreshData();
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public void setParentPane(JSplitPane jSplitPane, double d) {
        if (jSplitPane == null && this.parentPane != null) {
            this.parentPane.setBottomComponent(null);
        } else if (jSplitPane != null) {
            jSplitPane.setBottomComponent((Component)((Object)this.chartPanel));
            jSplitPane.setDividerLocation(d);
            this.dividerLocation = d;
        }
        this.parentPane = jSplitPane;
    }

    public ChartWindow getChartWindow() {
        return this.chartWindow;
    }

    public void setChartWindow(ChartWindow chartWindow) {
        this.chartWindow = chartWindow;
        if (chartWindow != null) {
            this.chartPanel.setFloatMode(1);
        } else {
            this.chartPanel.setFloatMode(0);
        }
    }

    public PropertyChangeListener getPropertyChangeListener() {
        return this.changeListener;
    }

    public boolean isInteractive() {
        return this.chartPanel.isInteractive();
    }

    public void setInteractive(boolean bl) {
        this.chartPanel.setInteractive(bl);
    }

    public void setActiveGpxObject(GPXObject gPXObject) {
        this.dataset.clear();
        this.dataset.addWaypointGroups(GpsMaster.active.getGroups(3));
        this.refreshData();
        this.clearExtensionAxes();
        this.scanGpsData();
        this.scanExtensions();
        this.addExtensionAxes();
    }

    public ChartXAxis getXAxis() {
        return this.xAxis;
    }

    public void setXAxis(ChartXAxis chartXAxis) {
        this.xAxis = chartXAxis;
    }

    public ChartYAxis getYAxis() {
        return this.yAxis;
    }

    public void setYAxis(ChartYAxis chartYAxis) {
        XYItemRenderer xYItemRenderer = (XYItemRenderer)chartYAxis.getPreferredRenderer();
        if (xYItemRenderer == null) {
            xYItemRenderer = new XYAreaRenderer(4);
            this.plot.setRenderer(xYItemRenderer);
        }
        this.yAxis = chartYAxis;
    }

    public void terminate() {
        if (this.changeListener != null) {
            GpsMaster.active.removePropertyChangeListener(this.changeListener);
        }
    }

    private void handleTear(MouseEvent mouseEvent) {
        if (this.chartWindow != null) {
            if (!this.chartWindow.isVisible()) {
                this.panelToFrame();
            } else {
                this.frameToPanel();
            }
        }
    }

    private void panelToFrame() {
        if (this.chartWindow != null) {
            this.chartPanel.setFloatMode(2);
            this.chartWindow.setSize(new Dimension(600, 400));
            this.chartWindow.setChartPanel(this.chartPanel);
            this.chartWindow.setVisible(true);
        }
    }

    private void frameToPanel() {
        if (this.chartWindow != null) {
            this.chartPanel.setFloatMode(1);
            this.chartWindow.remove((Component)((Object)this.chartPanel));
            this.chartWindow.setVisible(false);
            this.parentPane.setBottomComponent((Component)((Object)this.chartPanel));
            this.parentPane.setDividerLocation(this.dividerLocation);
        }
    }

    private void makeListeners() {
        this.changeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("activeGpxObject")) {
                    ChartHandler.this.setActiveGpxObject(GpsMaster.active.getGpxObject());
                } else if (string.equals("refreshGpx")) {
                    ChartHandler.this.refreshData();
                }
            }
        };
        this.tearListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    ChartHandler.this.handleTear(mouseEvent);
                }
            }
        };
    }

    private void init() {
        this.xAxis = new DistanceAxis(this.uc);
        this.yAxis = new ElevationAxis(this.uc);
        this.plot = new XYPlot();
        this.plot.setOrientation(PlotOrientation.VERTICAL);
        this.plot.setForegroundAlpha(0.75f);
        XYAreaRenderer xYAreaRenderer = new XYAreaRenderer(4);
        this.plot.setRenderer((XYItemRenderer)xYAreaRenderer);
        this.chart = new InteractiveChart(this.plot);
        GpsMasterChartTheme gpsMasterChartTheme = new GpsMasterChartTheme("GpsMaster");
        gpsMasterChartTheme.apply(this.chart);
        this.chartPanel = new FloatableChartPanel(this.chart);
        this.chartPanel.setChart(this.chart);
        this.chartPanel.getFloatComponent().addMouseListener(this.tearListener);
        this.chartPanel.setFloatMode(0);
        this.xCombo = this.chartPanel.getxCombo();
        this.xCombo.setRenderer(new ComboAxisRenderer());
        this.xCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ChartHandler.this.handleComboSelection(ChartHandler.this.xCombo, "X");
            }
        });
        this.xCombo.setToolTipText("If anyone knows how to make this transparent, please let me know");
        this.xCombo.setFocusable(false);
        this.xCombo.setBorder(null);
        this.xCombo.addItem(new DistanceAxis(this.uc));
        this.xCombo.addItem(new TimeAxis(this.uc));
        this.xCombo.addItem(new DurationAxis(this.uc));
        this.yCombo = this.chartPanel.getyCombo();
        this.yCombo.setRenderer(new ComboAxisRenderer());
        this.yCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ChartHandler.this.handleComboSelection(ChartHandler.this.yCombo, "Y");
            }
        });
        this.yCombo.setToolTipText("Select data for this axis");
        this.yCombo.setFocusable(false);
        this.yCombo.setBorder(null);
        this.yCombo.addItem(new ElevationAxis(this.uc));
        this.yCombo.addItem(new SpeedAxis(this.uc));
    }

    protected void handleComboSelection(JComboBox<ChartAxis> jComboBox, String string) {
        if (string.equals("X")) {
            this.xAxis = (ChartXAxis)jComboBox.getSelectedItem();
            this.refreshData();
        }
        if (string.equals("Y")) {
            this.yAxis = (ChartYAxis)jComboBox.getSelectedItem();
            this.refreshData();
        }
    }

    private void refreshData() {
        this.yAxis.setPadding(0.1f);
        this.xAxis.reset();
        this.dataset.setXAxis(this.xAxis);
        this.yAxis.reset();
        this.dataset.setYAxis(this.yAxis);
        this.chart.setChartDataset(this.dataset);
        String string = this.yAxis.getTitle().concat(" Chart");
        this.chartPanel.setChartTitle(string);
        for (WaypointGroup waypointGroup : this.dataset.getWaypointGroups()) {
            int n = this.dataset.getWaypointGroups().indexOf(waypointGroup);
            this.plot.getRenderer().setSeriesPaint(n, (Paint)waypointGroup.getColor());
        }
    }

    private void clearExtensionAxes() {
        for (int i = 0; i < this.yCombo.getItemCount(); ++i) {
            if (this.yCombo.getItemAt(i) instanceof ExtensionAxis) {
                this.yCombo.removeItemAt(i);
            }
            if (!(this.yCombo.getItemAt(i) instanceof GpsDataAxis)) continue;
            this.yCombo.removeItemAt(i);
        }
    }

    private void addExtensionAxes() {
        for (String string : this.extKeys) {
            this.yCombo.addItem(new ExtensionAxis(string));
        }
    }

    private void scanExtensions() {
        this.extKeys.clear();
        for (WaypointGroup waypointGroup : this.dataset.getWaypointGroups()) {
            int n = Math.min(50, waypointGroup.getNumPts());
            for (int i = 0; i < n; ++i) {
                for (GPXExtension gPXExtension : waypointGroup.getWaypoints().get(i).getExtension().getExtensions()) {
                    String string = gPXExtension.getKey();
                    String string2 = gPXExtension.getValue();
                    if (string2 == null) continue;
                    try {
                        Double.parseDouble(string2);
                        if (this.extKeys.contains(string)) continue;
                        this.extKeys.add(string);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
        }
    }

    private void scanGpsData() {
        this.gpsFields.clear();
        for (WaypointGroup waypointGroup : this.dataset.getWaypointGroups()) {
            int n = Math.min(50, waypointGroup.getNumPts());
            block1: for (byte by = 0; by <= 4; by = (byte)(by + 1)) {
                GpsDataAxis gpsDataAxis = new GpsDataAxis(by);
                for (int i = 0; i < n; ++i) {
                    if (gpsDataAxis.getValue(waypointGroup.getWaypoints().get(i)) == 0.0) continue;
                    if (this.gpsFields.contains(by)) continue block1;
                    this.gpsFields.add(by);
                    this.yCombo.addItem(gpsDataAxis);
                    continue block1;
                }
            }
        }
    }
}

