/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.chart;

import java.util.ArrayList;
import java.util.List;
import org.gpsmaster.chart.ChartXAxis;
import org.gpsmaster.chart.ChartYAxis;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.gpxpanel.WaypointGroup;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class ChartDataset {
    private List<WaypointGroup> groups = null;
    private XYSeriesCollection collection = new XYSeriesCollection();
    private ChartXAxis xAxis = null;
    private ChartYAxis yAxis = null;

    public ChartDataset() {
        this.groups = new ArrayList<WaypointGroup>();
    }

    public ChartXAxis getXAxis() {
        return this.xAxis;
    }

    public void setXAxis(ChartXAxis chartXAxis) {
        this.xAxis = chartXAxis;
    }

    public ChartYAxis getYAxis() {
        return this.yAxis;
    }

    public void setYAxis(ChartYAxis chartYAxis) {
        this.yAxis = chartYAxis;
    }

    public ValueAxis getDomainAxis() {
        return this.xAxis.getValueAxis();
    }

    public ValueAxis getRangeAxis() {
        return this.yAxis.getValueAxis();
    }

    public void addWaypointGroup(WaypointGroup waypointGroup) {
        this.groups.add(waypointGroup);
    }

    public void addWaypointGroups(List<WaypointGroup> list) {
        this.groups.addAll(list);
    }

    public void removeWaypointGroup(WaypointGroup waypointGroup) {
        if (this.groups.contains(waypointGroup)) {
            this.groups.remove(waypointGroup);
        }
    }

    public List<WaypointGroup> getWaypointGroups() {
        return this.groups;
    }

    public WaypointGroup findGroup(Waypoint waypoint) {
        for (WaypointGroup waypointGroup : this.groups) {
            if (!waypointGroup.getWaypoints().contains(waypoint)) continue;
            return waypointGroup;
        }
        return null;
    }

    public XYSeriesCollection getCollection() {
        this.fillDataset();
        return this.collection;
    }

    public Waypoint getWaypointForX(double d) {
        Waypoint waypoint = null;
        int n = -1;
        for (int i = 0; i < this.groups.size(); ++i) {
            int[] nArray = DatasetUtilities.findItemIndicesForX((XYDataset)this.collection, (int)i, (double)d);
            if (nArray[0] == -1) continue;
            n = nArray[0];
            return this.groups.get(i).getWaypoints().get(n);
        }
        return waypoint;
    }

    public void clear() {
        this.collection.removeAllSeries();
        this.groups.clear();
    }

    public void refresh() {
        this.collection.removeAllSeries();
        this.fillDataset();
    }

    private void fillDataset() {
        if (this.xAxis == null) {
            throw new NullPointerException("X-Axis not set, use setXAxis()");
        }
        if (this.yAxis == null) {
            throw new NullPointerException("Y-Axis not set, use setYAxis()");
        }
        this.collection.removeAllSeries();
        this.xAxis.reset();
        this.yAxis.reset();
        for (WaypointGroup waypointGroup : this.groups) {
            int n = this.groups.indexOf(waypointGroup);
            XYSeries xYSeries = new XYSeries((Comparable)Integer.valueOf(n));
            for (Waypoint waypoint : waypointGroup.getWaypoints()) {
                double d = this.xAxis.getValue(waypoint);
                double d2 = this.yAxis.getValue(waypoint);
                xYSeries.add(d, d2);
            }
            this.collection.addSeries(xYSeries);
        }
    }

    public double lookupXValue(Waypoint waypoint) {
        return this.xAxis.lookupValue(waypoint);
    }
}

