/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster;

import eu.fuegenstein.messagecenter.MessageCenter;
import eu.fuegenstein.util.ClassUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.gpsmaster.GpsMaster;
import org.gpsmaster.gpxpanel.GPXExtension;
import org.gpsmaster.gpxpanel.GPXFile;
import org.gpsmaster.widget.ActivityWidget;

public class ActivityHandler {
    private MessageCenter msg = null;
    private JPanel panel = null;
    private GPXFile gpxFile = null;
    private JToolBar pickerBar = null;
    private JScrollPane scrollPane = null;
    private Container pickerContainer = null;
    private ActivityWidget widget = new ActivityWidget();
    private ActionListener widgetListener = null;
    private ActionListener pickerListener = null;
    private PropertyChangeListener changeListener = null;

    public ActivityHandler(JPanel jPanel, Container container, MessageCenter messageCenter) {
        this.panel = jPanel;
        this.msg = messageCenter;
        this.pickerContainer = container;
        this.widgetListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActivityHandler.this.checkPicker();
            }
        };
        this.pickerListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JButton jButton = (JButton)actionEvent.getSource();
                ActivityWidget activityWidget = (ActivityWidget)jButton.getParent();
                ActivityHandler.this.setActivity(activityWidget.getActivity());
                GPXExtension gPXExtension = ActivityHandler.this.gpxFile.getExtension().getExtension("gpsm:activity");
                if (gPXExtension != null) {
                    gPXExtension.setValue(activityWidget.getActivity());
                } else {
                    ActivityHandler.this.gpxFile.getExtension().add("gpsm:activity", activityWidget.getActivity());
                }
                ActivityHandler.this.closePicker();
            }
        };
        this.changeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ActivityHandler.this.setGpxFile(GpsMaster.active.getGpxFile());
            }
        };
        GpsMaster.active.addPropertyChangeListener(this.changeListener);
        this.widget.addActionListener(this.widgetListener);
        this.widget.setVisible(false);
    }

    private void setGpxFile(GPXFile gPXFile) {
        if (this.gpxFile == null) {
            this.gpxFile = gPXFile;
            this.checkGpxFile();
        } else if (!this.gpxFile.equals(gPXFile)) {
            this.gpxFile = gPXFile;
            this.checkGpxFile();
        }
    }

    public GPXFile getGpxFile() {
        return this.gpxFile;
    }

    public ActivityWidget getWidget() {
        return this.widget;
    }

    public String getActivity() {
        return this.widget.getActivity();
    }

    public void setActivity(String string) {
        if (!string.equals(this.widget.getActivity())) {
            this.widget.setActivity(string);
        }
        this.widgetOn();
    }

    private void checkPicker() {
        if (this.scrollPane == null) {
            this.makePicker();
        } else {
            this.closePicker();
        }
    }

    private void makePicker() {
        this.pickerBar = new JToolBar(1);
        this.pickerBar.setFloatable(false);
        this.pickerBar.setBackground(Color.WHITE);
        this.scrollPane = new JScrollPane(this.pickerBar);
        try {
            for (String string : ClassUtils.getResources("org/gpsmaster/icons/activities/")) {
                if (string.startsWith("_")) continue;
                ActivityWidget activityWidget = new ActivityWidget();
                activityWidget.setActivity(string.replace(".png", ""));
                activityWidget.addActionListener(this.pickerListener);
                this.pickerBar.add(activityWidget);
            }
            this.pickerContainer.add((Component)this.scrollPane, "East");
            this.pickerContainer.validate();
        }
        catch (Exception exception) {
            this.msg.error("Unable to get icon list", exception);
        }
    }

    private void closePicker() {
        this.pickerContainer.remove(this.scrollPane);
        this.pickerContainer.validate();
        this.scrollPane = null;
    }

    private void widgetOn() {
        if (!this.widget.isVisible()) {
            this.widget.setVisible(true);
            this.panel.add(this.widget);
        }
    }

    private void widgetOff() {
        if (this.widget.isVisible()) {
            this.widget.setVisible(false);
            this.panel.remove(this.widget);
        }
    }

    private void checkGpxFile() {
        if (this.gpxFile != null) {
            GPXExtension gPXExtension = this.gpxFile.getExtension().getExtension("gpsm:activity");
            if (gPXExtension != null) {
                this.setActivity(gPXExtension.getValue());
                this.widgetOn();
            } else {
                this.setActivity("_notset");
            }
        } else {
            this.widgetOff();
        }
    }
}

