/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.provider;

import net.sf.marineapi.nmea.io.SentenceReader;
import net.sf.marineapi.nmea.sentence.GGASentence;
import net.sf.marineapi.nmea.sentence.GLLSentence;
import net.sf.marineapi.nmea.sentence.RMCSentence;
import net.sf.marineapi.nmea.sentence.Sentence;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.util.DataStatus;
import net.sf.marineapi.nmea.util.Date;
import net.sf.marineapi.nmea.util.FaaMode;
import net.sf.marineapi.nmea.util.GpsFixQuality;
import net.sf.marineapi.nmea.util.Position;
import net.sf.marineapi.nmea.util.Time;
import net.sf.marineapi.provider.AbstractProvider;
import net.sf.marineapi.provider.event.PositionEvent;

public class PositionProvider
extends AbstractProvider<PositionEvent> {
    public PositionProvider(SentenceReader reader) {
        super(reader, SentenceId.RMC, SentenceId.GGA, SentenceId.GLL);
    }

    @Override
    protected PositionEvent createProviderEvent() {
        Position p = null;
        Double sog = null;
        Double cog = null;
        Date d = null;
        Time t = null;
        FaaMode mode = null;
        GpsFixQuality fix = null;
        for (Sentence s : this.getSentences()) {
            if (s instanceof RMCSentence) {
                RMCSentence rmc = (RMCSentence)s;
                sog = rmc.getSpeed();
                cog = rmc.getCourse();
                d = rmc.getDate();
                t = rmc.getTime();
                mode = rmc.getMode();
                if (p != null) continue;
                p = rmc.getPosition();
                continue;
            }
            if (s instanceof GGASentence) {
                GGASentence gga = (GGASentence)s;
                p = gga.getPosition();
                fix = gga.getFixQuality();
                continue;
            }
            if (!(s instanceof GLLSentence) || p != null) continue;
            GLLSentence gll = (GLLSentence)s;
            p = gll.getPosition();
        }
        return new PositionEvent(this, p, sog, cog, d, t, mode, fix);
    }

    @Override
    protected boolean isReady() {
        return this.hasOne("RMC") && this.hasOne("GGA", "GLL");
    }

    @Override
    protected boolean isValid() {
        for (Sentence s : this.getSentences()) {
            GpsFixQuality fq;
            DataStatus ds;
            if (s instanceof RMCSentence) {
                ds = ((RMCSentence)s).getStatus();
                FaaMode gm = ((RMCSentence)s).getMode();
                if (!DataStatus.VOID.equals((Object)ds) && !FaaMode.NONE.equals((Object)gm)) continue;
                return false;
            }
            if (!(s instanceof GGASentence ? GpsFixQuality.INVALID.equals((Object)(fq = ((GGASentence)s).getFixQuality())) : s instanceof GLLSentence && DataStatus.VOID.equals((Object)(ds = ((GLLSentence)s).getStatus())))) continue;
            return false;
        }
        return true;
    }
}

