/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.util;

import net.sf.marineapi.nmea.util.CompassPoint;
import net.sf.marineapi.nmea.util.Datum;
import net.sf.marineapi.nmea.util.Waypoint;

public class Position {
    private double latitude;
    private double longitude;
    private double altitude = 0.0;
    private Datum datum = Datum.WGS84;

    public Position(double lat, double lon) {
        this.setLatitude(lat);
        this.setLongitude(lon);
    }

    public Position(double lat, double lon, double alt) {
        this(lat, lon);
        this.altitude = alt;
    }

    public Position(double lat, double lon, Datum datum) {
        this(lat, lon);
        this.datum = datum;
    }

    public Position(double lat, double lon, double alt, Datum datum) {
        this(lat, lon, alt);
        this.datum = datum;
    }

    public double distanceTo(Position pos) {
        return this.haversine(this.getLatitude(), this.getLongitude(), pos.getLatitude(), pos.getLongitude());
    }

    public double getAltitude() {
        return this.altitude;
    }

    public Datum getDatum() {
        return this.datum;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public CompassPoint getLatitudeHemisphere() {
        return this.isLatitudeNorth() ? CompassPoint.NORTH : CompassPoint.SOUTH;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public CompassPoint getLongitudeHemisphere() {
        return this.isLongitudeEast() ? CompassPoint.EAST : CompassPoint.WEST;
    }

    public boolean isLatitudeNorth() {
        return this.getLatitude() >= 0.0;
    }

    public boolean isLongitudeEast() {
        return this.getLongitude() >= 0.0;
    }

    public void setAltitude(double altitude) {
        this.altitude = altitude;
    }

    public void setLatitude(double latitude) {
        if (latitude < -90.0 || latitude > 90.0) {
            throw new IllegalArgumentException("Latitude out of bounds -90..90 degrees");
        }
        this.latitude = latitude;
    }

    public void setLongitude(double longitude) {
        if (longitude < -180.0 || longitude > 180.0) {
            throw new IllegalArgumentException("Longitude out of bounds -180..180 degrees");
        }
        this.longitude = longitude;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(String.format("%02.04f", Math.abs(this.getLatitude())));
        sb.append(" ");
        sb.append(this.getLatitudeHemisphere().toChar());
        sb.append(", ");
        sb.append(String.format("%03.04f", Math.abs(this.getLongitude())));
        sb.append(" ");
        sb.append(this.getLongitudeHemisphere().toChar());
        sb.append(", ");
        sb.append(this.getAltitude());
        sb.append(" m]");
        return sb.toString();
    }

    public Waypoint toWaypoint(String id) {
        return new Waypoint(id, this.getLatitude(), this.getLongitude());
    }

    private double haversine(double lat1, double lon1, double lat2, double lon2) {
        double earthRadius = 6366.70702;
        double dLat = Math.toRadians(lat2 - lat1);
        double dLon = Math.toRadians(lon2 - lon1);
        double a = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.cos(Math.toRadians(lat1)) * Math.cos(Math.toRadians(lat2)) * Math.sin(dLon / 2.0) * Math.sin(dLon / 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return 6366.70702 * c * 1000.0;
    }
}

