/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.util;

import java.util.GregorianCalendar;
import net.sf.marineapi.nmea.util.Time;

public class Date {
    private static final String DATE_PATTERN = "%d-%02d-%02d";
    public static final int PIVOT_YEAR = 50;
    private int day;
    private int month;
    private int year;

    public Date() {
        GregorianCalendar c = new GregorianCalendar();
        this.year = c.get(1);
        this.month = c.get(2) + 1;
        this.day = c.get(5);
    }

    public Date(String date) {
        this.setDay(Integer.parseInt(date.substring(0, 2)));
        this.setMonth(Integer.parseInt(date.substring(2, 4)));
        this.setYear(Integer.parseInt(date.substring(4)));
    }

    public Date(int year, int month, int day) {
        this.setYear(year);
        this.setMonth(month);
        this.setDay(day);
    }

    public boolean equals(Object obj) {
        Date d;
        if (obj == this) {
            return true;
        }
        return obj instanceof Date && (d = (Date)obj).getDay() == this.getDay() && d.getMonth() == this.getMonth() && d.getYear() == this.getYear();
    }

    public int getDay() {
        return this.day;
    }

    public int getMonth() {
        return this.month;
    }

    public int getYear() {
        return this.year;
    }

    public int hashCode() {
        return this.toISO8601().hashCode();
    }

    public void setDay(int day) {
        if (day < 1 || day > 31) {
            throw new IllegalArgumentException("Day out of bounds [1..31]");
        }
        this.day = day;
    }

    public void setMonth(int month) {
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("Month value out of bounds [1..12]");
        }
        this.month = month;
    }

    public void setYear(int year) {
        if (year < 0 || year > 99 && year < 1000 || year > 9999) {
            throw new IllegalArgumentException("Year must be two or four digit value");
        }
        this.year = year < 100 && year > 50 ? 1900 + year : (year < 100 && year <= 50 ? 2000 + year : year);
    }

    public String toString() {
        int y = this.getYear();
        String ystr = String.valueOf(y);
        String year = ystr.substring(2);
        String date = String.format("%02d%02d%s", this.getDay(), this.getMonth(), year);
        return date;
    }

    public String toISO8601() {
        return String.format(DATE_PATTERN, this.getYear(), this.getMonth(), this.getDay());
    }

    public String toISO8601(Time t) {
        return this.toISO8601().concat("T").concat(t.toISO8601());
    }

    public java.util.Date toDate() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1, this.getYear());
        cal.set(2, this.getMonth());
        cal.set(5, this.getDay());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }
}

