/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import net.sf.marineapi.nmea.parser.BODParser;
import net.sf.marineapi.nmea.parser.DBTParser;
import net.sf.marineapi.nmea.parser.DPTParser;
import net.sf.marineapi.nmea.parser.GGAParser;
import net.sf.marineapi.nmea.parser.GLLParser;
import net.sf.marineapi.nmea.parser.GSAParser;
import net.sf.marineapi.nmea.parser.GSVParser;
import net.sf.marineapi.nmea.parser.HDGParser;
import net.sf.marineapi.nmea.parser.HDMParser;
import net.sf.marineapi.nmea.parser.HDTParser;
import net.sf.marineapi.nmea.parser.MTAParser;
import net.sf.marineapi.nmea.parser.MTWParser;
import net.sf.marineapi.nmea.parser.MWVParser;
import net.sf.marineapi.nmea.parser.RMBParser;
import net.sf.marineapi.nmea.parser.RMCParser;
import net.sf.marineapi.nmea.parser.ROTParser;
import net.sf.marineapi.nmea.parser.RTEParser;
import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.parser.VHWParser;
import net.sf.marineapi.nmea.parser.VTGParser;
import net.sf.marineapi.nmea.parser.WPLParser;
import net.sf.marineapi.nmea.parser.XDRParser;
import net.sf.marineapi.nmea.parser.ZDAParser;
import net.sf.marineapi.nmea.sentence.Sentence;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TalkerId;

public final class SentenceFactory {
    private static Map<String, Class<? extends SentenceParser>> parsers = new HashMap<String, Class<? extends SentenceParser>>();
    private static volatile SentenceFactory instance;

    private SentenceFactory() {
        this.registerParser("BOD", BODParser.class);
        this.registerParser("DBT", DBTParser.class);
        this.registerParser("DPT", DPTParser.class);
        this.registerParser("GGA", GGAParser.class);
        this.registerParser("GLL", GLLParser.class);
        this.registerParser("GSA", GSAParser.class);
        this.registerParser("GSV", GSVParser.class);
        this.registerParser("HDG", HDGParser.class);
        this.registerParser("HDM", HDMParser.class);
        this.registerParser("HDT", HDTParser.class);
        this.registerParser("MTA", MTAParser.class);
        this.registerParser("MTW", MTWParser.class);
        this.registerParser("MWV", MWVParser.class);
        this.registerParser("RMB", RMBParser.class);
        this.registerParser("RMC", RMCParser.class);
        this.registerParser("RTE", RTEParser.class);
        this.registerParser("VHW", VHWParser.class);
        this.registerParser("VTG", VTGParser.class);
        this.registerParser("WPL", WPLParser.class);
        this.registerParser("XDR", XDRParser.class);
        this.registerParser("ZDA", ZDAParser.class);
        this.registerParser("ROT", ROTParser.class);
    }

    public Sentence createParser(String nmea) {
        String sid = SentenceId.parseStr(nmea);
        return this.createParserImpl(sid, nmea);
    }

    public Sentence createParser(TalkerId talker, SentenceId type) {
        return this.createParser(talker, type.toString());
    }

    public Sentence createParser(TalkerId talker, String type) {
        if (talker == null) {
            throw new IllegalArgumentException("TalkerId cannot be null");
        }
        return this.createParserImpl(type, (Object)talker);
    }

    public boolean hasParser(String type) {
        return parsers.containsKey(type);
    }

    public void registerParser(String type, Class<? extends SentenceParser> parser) {
        try {
            parser.getConstructor(String.class);
            parser.getConstructor(TalkerId.class);
            parsers.put(type, parser);
        }
        catch (SecurityException e) {
            String msg = "Unable to register parser due security violation";
            throw new IllegalArgumentException(msg, e);
        }
        catch (NoSuchMethodException e) {
            String msg = "Required constructors not found; SentenceParser(String), SentenceParser(TalkerId)";
            throw new IllegalArgumentException(msg, e);
        }
    }

    public void unregisterParser(Class<? extends SentenceParser> parser) {
        for (String key : parsers.keySet()) {
            if (parsers.get(key) != parser) continue;
            parsers.remove(key);
            break;
        }
    }

    private Sentence createParserImpl(String sid, Object param) {
        if (!this.hasParser(sid)) {
            String msg = String.format("Parser for type '%s' not found", sid);
            throw new IllegalArgumentException(msg);
        }
        Sentence parser = null;
        Class<?> klass = param.getClass();
        try {
            Class<? extends SentenceParser> c = parsers.get(sid);
            Constructor<? extends SentenceParser> co = c.getConstructor(klass);
            parser = co.newInstance(param);
        }
        catch (NoSuchMethodException e) {
            String name = klass.getName();
            String msg = "Constructor with %s parameter not found";
            throw new IllegalStateException(String.format(msg, name), e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Unable to instantiate parser", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unable to access parser", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Unable to invoke parser constructor", e);
        }
        return parser;
    }

    public static SentenceFactory getInstance() {
        if (instance == null) {
            instance = new SentenceFactory();
        }
        return instance;
    }
}

