/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.HDGSentence;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TalkerId;
import net.sf.marineapi.nmea.util.CompassPoint;

class HDGParser
extends SentenceParser
implements HDGSentence {
    private static final int HEADING = 0;
    private static final int DEVIATION = 1;
    private static final int DEV_DIRECTION = 2;
    private static final int VARIATION = 3;
    private static final int VAR_DIRECTION = 4;

    public HDGParser(String nmea) {
        super(nmea, SentenceId.HDG);
    }

    public HDGParser(TalkerId talker) {
        super(talker, SentenceId.HDG, 5);
    }

    @Override
    public double getDeviation() {
        double dev = this.getDoubleValue(1);
        if (dev == 0.0) {
            return dev;
        }
        CompassPoint dir = CompassPoint.valueOf(this.getCharValue(2));
        return dir == CompassPoint.WEST ? -dev : dev;
    }

    @Override
    public double getHeading() {
        return this.getDoubleValue(0);
    }

    @Override
    public double getVariation() {
        double var = this.getDoubleValue(3);
        if (var == 0.0) {
            return var;
        }
        CompassPoint dir = CompassPoint.valueOf(this.getCharValue(4));
        return dir == CompassPoint.WEST ? -var : var;
    }

    @Override
    public boolean isTrue() {
        return false;
    }

    @Override
    public void setDeviation(double deviation) {
        if (deviation < -180.0 || deviation > 180.0) {
            throw new IllegalArgumentException("Value out of range [-180..180]");
        }
        if (deviation > 0.0) {
            this.setCharValue(2, CompassPoint.EAST.toChar());
        } else if (deviation < 0.0) {
            this.setCharValue(2, CompassPoint.WEST.toChar());
        } else {
            this.setStringValue(2, "");
        }
        this.setDoubleValue(1, Math.abs(deviation), 3, 1);
    }

    @Override
    public void setHeading(double heading) {
        this.setDegreesValue(0, heading);
    }

    @Override
    public void setVariation(double variation) {
        if (variation < -180.0 || variation > 180.0) {
            throw new IllegalArgumentException("Value out of range [-180..180]");
        }
        if (variation > 0.0) {
            this.setCharValue(4, CompassPoint.EAST.toChar());
        } else if (variation < 0.0) {
            this.setCharValue(4, CompassPoint.WEST.toChar());
        } else {
            this.setStringValue(4, "");
        }
        this.setDoubleValue(3, Math.abs(variation), 3, 1);
    }
}

