/*
 * Decompiled with CFR 0.152.
 */
package eu.fuegenstein.swing;

import eu.fuegenstein.swing.NamedColor;
import java.awt.Color;
import javax.xml.bind.annotation.XmlTransient;

public class NamedConfigColor {
    private String colorString = "";
    private String name = "";

    public NamedConfigColor() {
    }

    public NamedConfigColor(NamedColor namedColor) {
        this.name = namedColor.getName();
        this.colorString = String.format("%02x%02x%02x%02x", namedColor.getRed(), namedColor.getGreen(), namedColor.getBlue(), namedColor.getAlpha());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getRGBA() {
        return this.colorString;
    }

    public void setRGBA(String string) {
        this.colorString = string;
    }

    @XmlTransient
    public NamedColor getNamedColor() {
        Color color;
        try {
            int n = Integer.parseInt(this.colorString.substring(0, 2), 16);
            int n2 = Integer.parseInt(this.colorString.substring(2, 4), 16);
            int n3 = Integer.parseInt(this.colorString.substring(4, 6), 16);
            int n4 = Integer.parseInt(this.colorString.substring(6, 8), 16);
            color = new Color(n, n2, n3, n4);
        }
        catch (NumberFormatException numberFormatException) {
            color = Color.WHITE;
        }
        return new NamedColor(color, this.name);
    }
}

