/*
 * Decompiled with CFR 0.152.
 */
package eu.fuegenstein.parameter;

import eu.fuegenstein.parameter.CommonParameter;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class RadioButtonParameter
extends CommonParameter {
    private String selected = null;
    private List<String> values = new ArrayList<String>();
    private ActionListener actionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
            RadioButtonParameter.this.setValue(jRadioButton.getText());
        }
    };

    public void addValue(String string) {
        this.values.add(string);
    }

    public void setValue(String string) {
        this.setValueString(string);
    }

    public String getValue() {
        return this.getValueString();
    }

    @Override
    public void setValueString(String string) {
        if (!this.values.contains(string)) {
            throw new IllegalArgumentException(string);
        }
        this.selected = string;
    }

    @Override
    protected void valueToString() {
    }

    @Override
    public String getValueString() {
        return this.selected;
    }

    @Override
    public JPanel getGuiComponent(Dimension dimension) {
        JPanel jPanel = new JPanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        jPanel.setBackground(this.backgroundColor);
        jPanel.setLayout(new FlowLayout(2));
        JLabel jLabel = new JLabel(this.description);
        jLabel.setHorizontalAlignment(4);
        jPanel.add(jLabel);
        for (String string : this.values) {
            JRadioButton jRadioButton = new JRadioButton(string);
            jRadioButton.addActionListener(this.actionListener);
            jRadioButton.setBackground(this.backgroundColor);
            if (this.values.indexOf(string) == 0) {
                jRadioButton.setSelected(true);
            }
            jPanel.add(jRadioButton);
            buttonGroup.add(jRadioButton);
        }
        return jPanel;
    }
}

