/*
 * Decompiled with CFR 0.152.
 */
package eu.fuegenstein.osm;

import eu.fuegenstein.osm.NominatimPlace;
import eu.fuegenstein.osm.NominatimResult;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class NominatimXmlHandler
extends DefaultHandler {
    private NominatimResult result = new NominatimResult();
    private NominatimPlace place = null;
    private String value = null;

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equals("searchresults")) {
            this.result.setAttribution(attributes.getValue("attribution"));
            this.result.setMoreUrl(attributes.getValue("more_url"));
        }
        if (string3.equals("addressparts") || string3.equals("place")) {
            this.place = new NominatimPlace();
            this.result.getPlaces().add(this.place);
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string4 = attributes.getLocalName(i);
                String string5 = attributes.getValue(i);
                if (string4.equals("display_name")) {
                    this.place.setDisplayName(string5);
                }
                if (string4.equals("lat")) {
                    this.place.setLat(Double.parseDouble(string5));
                }
                if (string4.equals("lon")) {
                    this.place.setLon(Double.parseDouble(string5));
                }
                this.place.getAll().put(string4, string5);
            }
        }
        this.value = null;
        super.startElement(string, string2, string3, attributes);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equals("village")) {
            this.place.setVillage(this.value);
        }
        if (string3.equals("county")) {
            this.place.setCounty(this.value);
        }
        if (string3.equals("state")) {
            this.place.setState(this.value);
        }
        if (string3.equals("country")) {
            this.place.setCountry(this.value);
        } else if (string3.equals("addressparts") || string3.equals("place")) {
            this.place = null;
        }
        if (this.place != null) {
            this.place.getAll().put(string3, this.value);
        }
        super.endElement(string, string2, string3);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        this.value = this.value == null ? string : this.value + string;
        super.characters(cArray, n, n2);
    }

    public NominatimResult getResult() {
        return this.result;
    }
}

