/*
 * Decompiled with CFR 0.152.
 */
package eu.fuegenstein.osm;

import eu.fuegenstein.osm.NominatimResult;
import eu.fuegenstein.osm.NominatimXmlHandler;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class Nominatim {
    private String userAgent = "Java " + this.getClass().getCanonicalName();
    private NominatimResult result = new NominatimResult();
    private int limit = 20;
    private String queryString = "";
    private String moreUrl = null;

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String string) {
        this.clear();
        try {
            this.queryString = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String string) {
        this.userAgent = string;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int n) {
        this.limit = n;
    }

    public NominatimResult lookup() throws Exception {
        String string = this.moreUrl == null ? "http://nominatim.openstreetmap.org/search/" + this.queryString + "?format=xml&addressdetails=1&limit=" + this.limit : this.moreUrl;
        this.result.clear();
        this.doSearch(string);
        return this.result;
    }

    public NominatimResult reverseLookup(double d, double d2) throws Exception {
        this.result = new NominatimResult();
        this.result.setLat(d);
        this.result.setLon(d2);
        String string = "http://nominatim.openstreetmap.org/reverse?lat=" + d + "&lon=" + d2;
        this.doSearch(string);
        return this.result;
    }

    public void clear() {
        this.moreUrl = null;
    }

    public boolean hasMore() {
        return this.moreUrl != null;
    }

    private void doSearch(String string) throws Exception {
        InputStream inputStream = null;
        NominatimXmlHandler nominatimXmlHandler = new NominatimXmlHandler();
        this.result.clear();
        URL uRL = new URL(string);
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setRequestProperty("User-Agent", this.userAgent);
        inputStream = uRLConnection.getInputStream();
        sAXParser.parse(inputStream, (DefaultHandler)nominatimXmlHandler);
        this.result = nominatimXmlHandler.getResult();
        this.moreUrl = this.result.getPlaces().size() > 0 ? this.result.getMoreUrl() : null;
    }
}

