/*
 * Decompiled with CFR 0.152.
 */
package eu.fuegenstein.messagecenter;

import eu.fuegenstein.messagecenter.MessageCenter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.SpringLayout;
import javax.swing.Timer;

public class MessagePanel
extends JPanel {
    public static final String PCE_CLOSE = "CLOSE";
    protected SpringLayout springLayout = new SpringLayout();
    protected JTextArea textArea = new JTextArea();
    protected Font font = new Font("Segoe UI", 0, 18);
    private int width = 800;
    private int screenTime = 0;
    protected boolean isCloseable = true;
    protected String messageText = "";
    private JProgressBar countdownBar = null;
    private Timer timer = null;
    private ActionListener timerListener = null;
    private MouseAdapter mouseListener = null;
    protected JLabel icon = new JLabel();

    public MessagePanel() {
        this.setVisible(true);
        this.setOpaque(true);
        this.setLayout(this.springLayout);
        this.countdownBar = new JProgressBar();
        this.countdownBar.setOrientation(1);
        this.countdownBar.setMinimum(0);
        this.countdownBar.setOpaque(true);
        this.countdownBar.setString("");
        this.countdownBar.setStringPainted(true);
        this.countdownBar.setBorder(BorderFactory.createEmptyBorder());
        this.mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    MessagePanel.this.firePropertyChange(MessagePanel.PCE_CLOSE, null, null);
                }
            }
        };
        this.icon.setIcon(new ImageIcon(MessageCenter.class.getResource("/eu/fuegenstein/icons/cancel.png")));
        this.icon.addMouseListener(this.mouseListener);
        this.timerListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MessagePanel.this.screenTime = MessagePanel.this.screenTime + -2;
                MessagePanel.this.countdownBar.setValue(MessagePanel.this.screenTime);
                if (MessagePanel.this.screenTime <= 0) {
                    MessagePanel.this.firePropertyChange(MessagePanel.PCE_CLOSE, null, null);
                    MessagePanel.this.timer.stop();
                }
            }
        };
        this.timer = new Timer(1000, this.timerListener);
        this.timer.setDelay(2000);
        this.textArea.setName("TextPane");
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setOpaque(false);
        this.textArea.setFont(this.font);
        this.textArea.setSize(this.width, 1000);
        this.textArea.setEditable(false);
        this.textArea.setVisible(true);
        this.add(this.textArea);
        this.layoutComponents();
    }

    public void setScreenTime(int n) {
        this.screenTime = n;
        if (n > 0) {
            this.countdownBar.setMaximum(n);
            this.countdownBar.setValue(n);
            this.countdownBar.setBackground(this.getBackground());
            this.countdownBar.setForeground(this.getBackground().darker());
            this.add(this.countdownBar);
            this.timer.start();
        } else {
            this.remove(this.countdownBar);
            this.timer.stop();
        }
        this.layoutComponents();
    }

    public int getScreenTime() {
        return this.screenTime;
    }

    public void setCloseable(boolean bl) {
        this.isCloseable = bl;
        if (bl) {
            this.add(this.icon);
        } else {
            this.remove(this.icon);
        }
        this.layoutComponents();
    }

    public boolean isCloseable() {
        return this.isCloseable;
    }

    public String getText() {
        return this.messageText;
    }

    public int getPanelWidth() {
        return this.width;
    }

    public void setPanelWidth(int n) {
        this.width = n;
        this.textArea.setSize(n, 1000);
        this.validate();
        Dimension dimension = new Dimension(this.textArea.getPreferredSize().width, this.textArea.getPreferredSize().height + 4);
        this.setPreferredSize(dimension);
    }

    public void setText(String string) {
        this.messageText = string;
        this.textArea.setText(string);
        this.validate();
        Dimension dimension = new Dimension(this.textArea.getPreferredSize().width, this.textArea.getPreferredSize().height + 4);
        this.setPreferredSize(dimension);
    }

    private void layoutComponents() {
        boolean bl = this.screenTime > 0;
        this.springLayout.removeLayoutComponent(this.icon);
        this.springLayout.removeLayoutComponent(this.countdownBar);
        this.springLayout.removeLayoutComponent(this.textArea);
        this.springLayout.putConstraint("West", (Component)this.textArea, 3, "West", (Component)this);
        this.springLayout.putConstraint("South", (Component)this.textArea, 0, "South", (Component)this);
        this.springLayout.putConstraint("North", (Component)this.textArea, 0, "North", (Component)this);
        if (this.isCloseable) {
            this.springLayout.putConstraint("East", (Component)this.icon, 0, "East", (Component)this);
            this.springLayout.putConstraint("North", (Component)this.icon, 0, "North", (Component)this);
        }
        if (bl) {
            this.springLayout.putConstraint("East", (Component)this.countdownBar, 0, "East", (Component)this);
            this.springLayout.putConstraint("South", (Component)this.countdownBar, 0, "South", (Component)this);
        }
        if (this.isCloseable && !bl) {
            this.springLayout.putConstraint("East", (Component)this.textArea, 0, "West", (Component)this.icon);
        }
        if (bl && !this.isCloseable) {
            this.springLayout.putConstraint("East", (Component)this.textArea, 0, "West", (Component)this.icon);
            this.springLayout.putConstraint("North", (Component)this.countdownBar, 0, "North", (Component)this);
        }
        if (bl && this.isCloseable) {
            this.springLayout.putConstraint("East", (Component)this.textArea, 0, "West", (Component)this.icon);
            this.springLayout.putConstraint("North", (Component)this.countdownBar, 0, "South", (Component)this.icon);
        }
    }
}

